/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNode;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNodeBucket;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNodeList;
import org.eclipse.sensinact.gateway.util.tree.PathNode;
import org.eclipse.sensinact.gateway.util.tree.PathNodeBucket;

public class PathNodeList<P extends PathNode<P>>
implements Iterable<P> {
    private final Object lock = new Object();
    private PathNodeBucket<?>[] table;
    private int threshold = 2;
    private int size = 0;
    private int length = 5;

    protected PathNodeList() {
        this.clear();
    }

    public void clear() {
        this.length = 5;
        this.size = 0;
        this.table = new PathNodeBucket[this.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P getStrictNode(String nodeName) {
        if (nodeName == null) {
            return null;
        }
        int hash = nodeName.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        Object object = this.lock;
        synchronized (object) {
            PathNodeBucket<Object> b = this.table[(hash & this.length - 2) + 1];
            while (b != null) {
                if (((PathNode)b.node).nodeName.equals(nodeName)) {
                    return b.node;
                }
                b = b.next;
            }
            b = this.table[0];
            while (b != null) {
                if (((PathNode)b.node).nodeName.equals(nodeName)) {
                    return b.node;
                }
                b = b.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<P> getPatternNodes(String nodeName) {
        if (nodeName == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            PathNodeBucket<Object> b = this.table[0];
            while (b != null) {
                if (((PathNode)b.node).equals(nodeName)) {
                    list.add(b.node);
                }
                b = b.next;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P add(P node) {
        if (node == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (++this.size > this.threshold) {
                PathNodeBucket<?>[] oldTable = this.table;
                int oldCapacity = this.length;
                this.length = oldCapacity * 2;
                this.table = new PathNodeBucket[this.length];
                this.threshold = (this.length >> 1) + (this.length >> 2);
                this.table[0] = oldTable[0];
                for (int j = 1; j < oldCapacity; ++j) {
                    PathNodeBucket<Object> b = oldTable[j];
                    while (b != null) {
                        PathNodeBucket<?> p = b;
                        b = b.next;
                        p.next = null;
                        this.add(p);
                    }
                }
            }
            this.add(new PathNodeBucket<P>(node));
        }
        return node;
    }

    private void add(PathNodeBucket<P> b) {
        int index = 0;
        if (!((PathNode)b.node).isPattern) {
            int hash = b.hash;
            hash ^= hash >>> 20 ^ hash >>> 12;
            hash ^= hash >>> 7 ^ hash >>> 4;
            index = (hash & this.length - 2) + 1;
        }
        PathNodeBucket<Object> bu = null;
        bu = this.table[index];
        if (bu == null) {
            this.table[index] = b;
        } else {
            while (bu.next != null) {
                bu = bu.next;
            }
            bu.next = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P remove(String nodeName) {
        if (nodeName == null) {
            return null;
        }
        int hash = nodeName.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        Object object = this.lock;
        synchronized (object) {
            int index = (hash & this.table.length - 2) + 1;
            PathNodeBucket<Object> b = this.table[index];
            PathNodeBucket<?> prev = null;
            while (b != null) {
                if (nodeName.equals(((PathNode)b.node).nodeName)) {
                    if (prev == null) {
                        this.table[index] = b.next;
                    } else {
                        prev.next = b.next;
                    }
                    --this.size;
                    return b.node;
                }
                prev = b;
                b = b.next;
            }
            b = this.table[0];
            prev = null;
            while (b != null) {
                if (nodeName.equals(((PathNode)b.node).nodeName)) {
                    if (prev == null) {
                        this.table[index] = b.next;
                    } else {
                        prev.next = b.next;
                    }
                    --this.size;
                    return b.node;
                }
                prev = b;
                b = b.next;
            }
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public <N extends ImmutablePathNode<N>> ImmutablePathNodeList<N> immutable(final N parent) {
        return new ImmutablePathNodeList(new ArrayList<ImmutablePathNodeBucket<N>>(){
            private static final long serialVersionUID = 1L;

            public List<ImmutablePathNodeBucket<N>> addAll() {
                int length = PathNodeList.this.table.length;
                for (int index = 0; index < length; ++index) {
                    if (PathNodeList.this.table[index] == null) {
                        super.add(null);
                        continue;
                    }
                    super.add(index, PathNodeList.this.table[index].immutable(parent.getClass(), parent));
                }
                return this;
            }
        }.addAll());
    }

    @Override
    public Iterator<P> iterator() {
        return new Iterator<P>(){
            int position = -1;
            PathNodeBucket<P> bucket = null;
            P node = null;

            @Override
            public boolean hasNext() {
                if (this.position == -1) {
                    this.next();
                }
                return this.node != null;
            }

            @Override
            public P next() {
                Object current = this.node;
                if (this.bucket != null) {
                    this.bucket = this.bucket.next;
                }
                if (this.bucket == null) {
                    while (++this.position < PathNodeList.this.length && (this.bucket = PathNodeList.this.table[this.position]) == null) {
                    }
                }
                this.node = this.bucket == null ? null : this.bucket.node;
                return current;
            }

            @Override
            public void remove() {
            }
        };
    }
}

