/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.CallbackService;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.internal.CallbackServlet;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.internal.CallbackWebSocketPool;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequireHttpWhiteboard
public class CallbackFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackFactory.class);
    private static ClassLoader loader = null;
    private Mediator mediator;
    private String appearingKey;
    private String disappearingKey;
    private Map<String, ServiceRegistration<?>> registrations;
    private final AtomicBoolean running;

    private static void findJettyClassLoader(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            if (!"org.apache.felix.http.jetty".equals(bundle.getSymbolicName())) continue;
            try {
                BundleWiring wire = (BundleWiring)bundle.adapt(BundleWiring.class);
                loader = wire.getClassLoader();
            }
            catch (Exception e) {
                e.printStackTrace();
                loader = WebSocketServlet.class.getClassLoader();
            }
            break;
        }
    }

    public CallbackFactory(Mediator mediator) {
        if (loader == null) {
            CallbackFactory.findJettyClassLoader(mediator.getContext());
        }
        this.mediator = mediator;
        this.registrations = Collections.synchronizedMap(new HashMap());
        this.running = new AtomicBoolean(false);
    }

    public void start() {
        if (this.running.get()) {
            return;
        }
        this.running.set(true);
        this.attachAll();
        this.appearingKey = this.mediator.attachOnServiceAppearing(CallbackService.class, (String)null, (Executable)new Executable<CallbackService, Void>(){

            public Void execute(CallbackService callbackService) throws Exception {
                CallbackFactory.this.attach(callbackService);
                return null;
            }
        });
        this.disappearingKey = this.mediator.attachOnServiceDisappearing(CallbackService.class, (String)null, (Executable)new Executable<CallbackService, Void>(){

            public Void execute(CallbackService callbackService) throws Exception {
                CallbackFactory.this.detach(callbackService);
                return null;
            }
        });
    }

    public void stop() {
        if (!this.running.get()) {
            return;
        }
        this.running.set(false);
        this.mediator.detachOnServiceAppearing(CallbackService.class, (String)null, this.appearingKey);
        this.mediator.detachOnServiceDisappearing(CallbackService.class, (String)null, this.disappearingKey);
        this.detachAll();
    }

    public void detachAll() {
        this.mediator.callServices(CallbackService.class, (Executable)new Executable<CallbackService, Void>(){

            public Void execute(CallbackService callbackService) throws Exception {
                CallbackFactory.this.detach(callbackService);
                return null;
            }
        });
    }

    public void attachAll() {
        this.mediator.callServices(CallbackService.class, (Executable)new Executable<CallbackService, Void>(){

            public Void execute(CallbackService callbackService) throws Exception {
                CallbackFactory.this.attach(callbackService);
                return null;
            }
        });
    }

    public final void attach(final CallbackService callbackService) {
        String key;
        Enumeration<String> enumKeys;
        Dictionary<String, ?> propsGiven;
        Hashtable<String, Object> props;
        if (callbackService == null || !this.running.get()) {
            return;
        }
        String endpoint = callbackService.getPattern();
        if (endpoint == null || endpoint.length() == 0 || "/".equals(endpoint)) {
            LOG.error("Invalid endpoint '%s' - expected '^|/([^/]+)(/([^/]+)*'", (Object)endpoint);
            return;
        }
        if (!endpoint.startsWith("/")) {
            endpoint = "/".concat(endpoint);
        }
        if (this.registrations.containsKey(endpoint)) {
            LOG.error("A callback service is already registered at '%s'", (Object)endpoint);
            return;
        }
        int callbackType = callbackService.getCallbackType();
        if ((callbackType & 1) == 1) {
            CallbackServlet callbackServlet = new CallbackServlet(this.mediator, callbackService);
            props = new Hashtable<String, Object>();
            propsGiven = callbackService.getProperties();
            enumKeys = propsGiven.keys();
            while (enumKeys.hasMoreElements()) {
                key = enumKeys.nextElement();
                ((Dictionary)props).put(key, propsGiven.get(key));
            }
            ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", endpoint);
            ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            ServiceRegistration registration = this.mediator.getContext().registerService(Servlet.class, (Object)callbackServlet, props);
            this.registrations.put(endpoint, registration);
        }
        if ((callbackType & 2) == 2) {
            String wsEndpoint = endpoint;
            if (!endpoint.startsWith("/ws/")) {
                wsEndpoint = "/ws".concat(endpoint);
            }
            props = new Hashtable();
            propsGiven = callbackService.getProperties();
            enumKeys = propsGiven.keys();
            while (enumKeys.hasMoreElements()) {
                key = enumKeys.nextElement();
                ((Dictionary)props).put(key, propsGiven.get(key));
            }
            ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", wsEndpoint);
            ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            WebSocketServlet webSocketServlet = new WebSocketServlet(){
                private static final long serialVersionUID = 1L;
                private CallbackWebSocketPool pool;
                private final AtomicBoolean firstCall;
                private final CountDownLatch initBarrier;
                {
                    this.pool = new CallbackWebSocketPool(CallbackFactory.this.mediator, callbackService);
                    this.firstCall = new AtomicBoolean(true);
                    this.initBarrier = new CountDownLatch(1);
                }

                public void init() throws ServletException {
                    LOG.info("The Echo servlet has been initialized, but we delay initialization until the first request so that a Jetty Context is available");
                }

                public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
                    if (this.firstCall.compareAndSet(true, false)) {
                        try {
                            this.delayedInit();
                        }
                        finally {
                            this.initBarrier.countDown();
                        }
                    }
                    try {
                        this.initBarrier.await();
                    }
                    catch (InterruptedException e) {
                        throw new ServletException("Timed out waiting for initialisation", (Throwable)e);
                    }
                    super.service(arg0, arg1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void delayedInit() throws ServletException {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader tccl = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(loader);
                    try {
                        super.init();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        currentThread.setContextClassLoader(tccl);
                    }
                }

                public void configure(WebSocketServletFactory factory) {
                    factory.getPolicy().setIdleTimeout(3600000L);
                    factory.setCreator((WebSocketCreator)this.pool);
                }
            };
            ServiceRegistration registration = this.mediator.getContext().registerService(new String[]{Servlet.class.getName(), WebSocketServlet.class.getName()}, (Object)webSocketServlet, props);
            this.registrations.put(wsEndpoint, registration);
            LOG.info(String.format("%s servlet registered", wsEndpoint));
        }
    }

    public final void detach(CallbackService callbackService) {
        ServiceRegistration<?> registration;
        if (callbackService == null) {
            return;
        }
        String endpoint = callbackService.getPattern();
        if (!endpoint.startsWith("/")) {
            endpoint = "/".concat(endpoint);
        }
        if ((registration = this.registrations.remove(endpoint)) != null) {
            try {
                registration.unregister();
                LOG.info("Callback servlet '%s' unregistered", (Object)endpoint);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            registration = null;
        }
        if (!endpoint.startsWith("/ws/") && (registration = this.registrations.remove("/ws".concat(endpoint))) != null) {
            try {
                registration.unregister();
                LOG.info("Callback servlet '%s' unregistered", (Object)endpoint);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            registration = null;
        }
    }
}

