/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.kodi.osgi;

import java.util.Hashtable;
import javax.servlet.Servlet;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpTaskConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.SimpleHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal.KodiDevicesDiscovery;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal.KodiRemoteControlHttpListener;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal.KodiResponsePacket;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal.KodiTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.osgi.KodiServiceMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpActivator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

@HttpTasks(tasks={@SimpleHttpTask(commands={Task.CommandType.GET, Task.CommandType.ACT}, configuration=@HttpTaskConfiguration(host="@context[kodi.ip]", path="/jsonrpc", contentType="application/json", httpMethod="POST", content=KodiTaskConfigurator.class), profile="")})
@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends HttpActivator {
    private static final String KODI_ENDPOINT = "/kodi/remote-control";
    private KodiDevicesDiscovery devicesDiscovery = null;

    public void connect(ExtModelConfiguration configuration) throws InvalidProtocolStackException {
        this.devicesDiscovery = new KodiDevicesDiscovery(this.mediator, this.endpoint, (String)((HttpMediator)this.mediator).getProperty("kodi.regex"));
        ((HttpMediator)this.mediator).attachOnServiceAppearing(HttpService.class, null, (Executable)new Executable<HttpService, Void>(){

            public Void execute(HttpService httpService) throws Exception {
                HttpContext hc = httpService.createDefaultHttpContext();
                httpService.registerServlet(Activator.KODI_ENDPOINT, (Servlet)new KodiRemoteControlHttpListener(Activator.this.endpoint, (KodiServiceMediator)Activator.this.mediator), new Hashtable(), hc);
                return null;
            }
        });
        ((HttpMediator)this.mediator).attachOnServiceDisappearing(HttpService.class, null, (Executable)new Executable<HttpService, Void>(){

            public Void execute(HttpService httpService) throws Exception {
                if (httpService != null) {
                    httpService.unregister(Activator.KODI_ENDPOINT);
                }
                return null;
            }
        });
        super.connect(configuration);
    }

    public void doStop() throws Exception {
        super.doStop();
        this.devicesDiscovery = null;
    }

    public HttpMediator doInstantiate(BundleContext context) {
        return new KodiServiceMediator(context);
    }

    public Class<? extends HttpPacket> getPacketType() {
        return KodiResponsePacket.class;
    }

    public HttpTaskProcessingContextFactory getTaskProcessingContextFactory() {
        return new DefaultHttpTaskProcessingContextFactory(this.mediator){

            public HttpTaskProcessingContext newInstance(HttpTaskConfigurator httpTaskConfigurator, String endpointId, HttpTask<?, ?> task) {
                return new KodiTaskProcessingContext(this.mediator, httpTaskConfigurator, endpointId, task);
            }
        };
    }

    private class KodiTaskProcessingContext
    extends DefaultHttpTaskProcessingContext {
        public KodiTaskProcessingContext(Mediator mediator, HttpTaskConfigurator httpTaskConfigurator, String endpointId, final HttpTask<?, ?> task) {
            super(mediator, httpTaskConfigurator, endpointId, task);
            this.properties.put("kodi.ip", new Executable<Void, String>(){

                public String execute(Void parameter) throws Exception {
                    String serviceProvider = UriUtils.getRoot((String)task.getUri()).substring(1);
                    return ((KodiServiceMediator)Activator.this.mediator).getKodiIP(serviceProvider);
                }
            });
        }
    }
}

