/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi;

import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.spi.IMatchingCondition;
import io.moquette.spi.MessageGUID;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;

public interface IMessagesStore {
    public void initStore();

    public void storeRetained(String var1, MessageGUID var2);

    public Collection<StoredMessage> searchMatching(IMatchingCondition var1);

    public MessageGUID storePublishForFuture(StoredMessage var1);

    public void dropMessagesInSession(String var1);

    public StoredMessage getMessageByGuid(MessageGUID var1);

    public void cleanRetained(String var1);

    public static class StoredMessage
    implements Serializable {
        final AbstractMessage.QOSType m_qos;
        final byte[] m_payload;
        final String m_topic;
        private boolean m_retained;
        private String m_clientID;
        private Integer m_msgID;
        private MessageGUID m_guid;

        public StoredMessage(byte[] message, AbstractMessage.QOSType qos, String topic) {
            this.m_qos = qos;
            this.m_payload = message;
            this.m_topic = topic;
        }

        public AbstractMessage.QOSType getQos() {
            return this.m_qos;
        }

        public ByteBuffer getPayload() {
            return (ByteBuffer)ByteBuffer.allocate(this.m_payload.length).put(this.m_payload).flip();
        }

        public String getTopic() {
            return this.m_topic;
        }

        public void setGuid(MessageGUID guid) {
            this.m_guid = guid;
        }

        public MessageGUID getGuid() {
            return this.m_guid;
        }

        public String getClientID() {
            return this.m_clientID;
        }

        public void setClientID(String m_clientID) {
            this.m_clientID = m_clientID;
        }

        public void setMessageID(Integer messageID) {
            this.m_msgID = messageID;
        }

        public Integer getMessageID() {
            return this.m_msgID;
        }

        public ByteBuffer getMessage() {
            return ByteBuffer.wrap(this.m_payload);
        }

        public void setRetained(boolean retained) {
            this.m_retained = retained;
        }

        public boolean isRetained() {
            return this.m_retained;
        }

        public String toString() {
            return "PublishEvent{m_msgID=" + this.m_msgID + ", clientID='" + this.m_clientID + '\'' + ", m_retain=" + this.m_retained + ", m_qos=" + (Object)((Object)this.m_qos) + ", m_topic='" + this.m_topic + '\'' + '}';
        }
    }
}

