/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.test;

import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.sensinact.gateway.app.api.function.AbstractFunction;
import org.eclipse.sensinact.gateway.app.basic.installer.BasicInstaller;
import org.eclipse.sensinact.gateway.app.basic.logic.BetweenFunction;
import org.eclipse.sensinact.gateway.app.basic.logic.DoubleConditionFunction;
import org.eclipse.sensinact.gateway.app.basic.logic.SimpleConditionFunction;
import org.eclipse.sensinact.gateway.app.basic.test.TestUtils;
import org.eclipse.sensinact.gateway.app.manager.json.AppFunction;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class TestLogicInstaller {
    private ComponentContext context;
    private BundleContext bundleContext;
    private Bundle bundle;

    @BeforeEach
    public void init() throws Exception {
        this.context = (ComponentContext)Mockito.mock(ComponentContext.class);
        this.bundle = (Bundle)Mockito.mock(Bundle.class);
        this.bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        Mockito.when((Object)this.bundleContext.getBundle()).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.context.getBundleContext()).thenReturn((Object)this.bundleContext);
    }

    public void testSimpleConditionCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_equals.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof SimpleConditionFunction));
        }
    }

    public void testDoubleConditionCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_and.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof DoubleConditionFunction));
        }
    }

    public void testBetweenConditionCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_in.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof BetweenFunction));
        }
    }
}

