/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.test;

import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.sensinact.gateway.app.api.function.AbstractFunction;
import org.eclipse.sensinact.gateway.app.basic.installer.BasicInstaller;
import org.eclipse.sensinact.gateway.app.basic.math.AdditionFunction;
import org.eclipse.sensinact.gateway.app.basic.math.DivisionFunction;
import org.eclipse.sensinact.gateway.app.basic.math.ModuloFunction;
import org.eclipse.sensinact.gateway.app.basic.math.MultiplicationFunction;
import org.eclipse.sensinact.gateway.app.basic.math.SubtractionFunction;
import org.eclipse.sensinact.gateway.app.basic.test.TestUtils;
import org.eclipse.sensinact.gateway.app.manager.json.AppFunction;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class TestMathInstaller {
    private ComponentContext context;
    private BundleContext bundleContext;
    private Bundle bundle;

    @BeforeEach
    public void init() throws Exception {
        this.context = (ComponentContext)Mockito.mock(ComponentContext.class);
        this.bundle = (Bundle)Mockito.mock(Bundle.class);
        this.bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        Mockito.when((Object)this.bundleContext.getBundle()).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.context.getBundleContext()).thenReturn((Object)this.bundleContext);
    }

    public void testAdditionCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_addition.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof AdditionFunction));
        }
    }

    public void testSubtractionCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_subtraction.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof SubtractionFunction));
        }
    }

    public void testMultiplicationCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_multiplication.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof MultiplicationFunction));
        }
    }

    public void testDivisionCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_division.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof DivisionFunction));
        }
    }

    public void testModuloCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/simple_modulo.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value").getJSONArray("application").getJSONObject(0);
            BasicInstaller installer = new BasicInstaller();
            installer.activate(this.context);
            AppFunction appFunction = new AppFunction(json.getJSONObject("function"));
            AbstractFunction function = installer.getFunction(appFunction);
            Assertions.assertTrue((boolean)(function instanceof ModuloFunction));
        }
    }
}

