/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.bundle;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class TrackerCustomizer<S>
implements ServiceTrackerCustomizer<S, S> {
    private Mediator mediator;
    private Map<String, List<Executable<S, Void>>> addingExecutables;
    private Map<String, List<Executable<S, Void>>> modifyingExecutables;
    private Map<String, List<Executable<S, Void>>> removingExecutables;

    private static <E> void execute(Collection<List<Executable<E, Void>>> executables, E instance) {
        if (executables.isEmpty()) {
            return;
        }
        for (List<Executable<E, Void>> execs : executables) {
            int length;
            if (execs.isEmpty()) continue;
            int n = length = execs == null ? 0 : execs.size();
            for (int index = 0; index < length; ++index) {
                try {
                    execs.get(index).execute(instance);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static final <E> String add(String prefix, Map<String, List<Executable<E, Void>>> map, List<Executable<E, Void>> executables) {
        if (executables == null || executables.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append("_");
        builder.append(executables.hashCode());
        builder.append(System.currentTimeMillis());
        String key = builder.toString();
        map.put(key, executables);
        return key;
    }

    TrackerCustomizer(Mediator mediator) {
        this.mediator = mediator;
        this.addingExecutables = new HashMap<String, List<Executable<S, Void>>>();
        this.modifyingExecutables = new HashMap<String, List<Executable<S, Void>>>();
        this.removingExecutables = new HashMap<String, List<Executable<S, Void>>>();
    }

    public String attachOnAdding(Executable<S, Void> executable) {
        return this.attachOnAdding(Collections.singletonList(executable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attachOnAdding(List<Executable<S, Void>> executables) {
        Map<String, List<Executable<S, Void>>> map = this.addingExecutables;
        synchronized (map) {
            return TrackerCustomizer.add("onAdding", this.addingExecutables, executables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachOnAdding(String key) {
        Map<String, List<Executable<S, Void>>> map = this.addingExecutables;
        synchronized (map) {
            this.addingExecutables.remove(key);
        }
    }

    public String attachOnModifying(Executable<S, Void> executable) {
        return this.attachOnModifying(Collections.singletonList(executable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attachOnModifying(List<Executable<S, Void>> executables) {
        Map<String, List<Executable<S, Void>>> map = this.modifyingExecutables;
        synchronized (map) {
            return TrackerCustomizer.add("onModifying", this.modifyingExecutables, executables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachOnModifying(String key) {
        Map<String, List<Executable<S, Void>>> map = this.modifyingExecutables;
        synchronized (map) {
            this.modifyingExecutables.remove(key);
        }
    }

    public String attachOnRemoving(Executable<S, Void> executable) {
        return this.attachOnRemoving(Collections.singletonList(executable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attachOnRemoving(List<Executable<S, Void>> executables) {
        Map<String, List<Executable<S, Void>>> map = this.removingExecutables;
        synchronized (map) {
            return TrackerCustomizer.add("onRemoving", this.removingExecutables, executables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachOnRemoving(String key) {
        Map<String, List<Executable<S, Void>>> map = this.removingExecutables;
        synchronized (map) {
            this.removingExecutables.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S addingService(ServiceReference<S> reference) {
        Object instance = this.mediator.getContext().getService(reference);
        Map<String, List<Executable<S, Void>>> map = this.addingExecutables;
        synchronized (map) {
            TrackerCustomizer.execute(this.addingExecutables.values(), instance);
        }
        return (S)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<S> reference, S instance) {
        Map<String, List<Executable<S, Void>>> map = this.modifyingExecutables;
        synchronized (map) {
            TrackerCustomizer.execute(this.modifyingExecutables.values(), instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<S> reference, S instance) {
        Map<String, List<Executable<S, Void>>> map = this.removingExecutables;
        synchronized (map) {
            TrackerCustomizer.execute(this.removingExecutables.values(), instance);
        }
    }
}

