/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.JSONUtils;

public abstract class ConstraintOnCollectionSize
implements Constraint {
    protected static final Logger LOGGER = Logger.getLogger(ConstraintOnCollectionSize.class.getCanonicalName());
    protected final String operator;
    protected final int length;
    protected final boolean complement;

    protected abstract boolean doComplies(int var1);

    public ConstraintOnCollectionSize(String operator, int length, boolean complement) {
        this.operator = operator;
        this.length = length;
        this.complement = complement;
    }

    public ConstraintOnCollectionSize(String operator, Object length, boolean complement) throws InvalidConstraintDefinitionException {
        this.operator = operator;
        this.complement = complement;
        try {
            this.length = (Integer)CastUtils.cast(Integer.TYPE, (Object)length);
        }
        catch (ClassCastException e) {
            throw new InvalidConstraintDefinitionException(e);
        }
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public boolean isComplement() {
        return this.complement;
    }

    @Override
    public boolean complies(Object value) {
        boolean complies;
        block7: {
            complies = false;
            if (value == null) {
                return complies;
            }
            if (Collection.class.isAssignableFrom(value.getClass())) {
                complies = this.doComplies(((Collection)value).size());
            } else if (value.getClass().isArray()) {
                complies = this.doComplies(Array.getLength(value));
            } else {
                try {
                    Object[] array = (Object[])CastUtils.castArray(Object[].class, (Object)value);
                    complies = this.complies(array);
                }
                catch (ClassCastException e) {
                    if (value.getClass() != String.class) break block7;
                    complies = this.doComplies(((String)value).length());
                }
            }
        }
        return complies ^ this.isComplement();
    }

    @Override
    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("operator");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.getOperator());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("complement");
        builder.append('\"');
        builder.append(':');
        builder.append(this.complement);
        builder.append(',');
        builder.append('\"');
        builder.append("operand");
        builder.append('\"');
        builder.append(':');
        builder.append(JSONUtils.toJSONFormat((Object)this.length));
        builder.append('}');
        return builder.toString();
    }
}

