/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.factory.packet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpConnectionConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponsePacket;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.HttpMappingProtocolStackConnectorCustomizer;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.MappingDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAwareHttpResponsePacket
extends HttpResponsePacket {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMappingProtocolStackConnectorCustomizer.class);
    private final MappingDescription[] mapping;
    private final String rawContentType;
    private final Charset charset;

    public TaskAwareHttpResponsePacket(HttpResponse response) {
        super(response, false, false);
        HttpConnectionConfiguration configuration = response.getConfiguration();
        if (configuration instanceof HttpTask) {
            HttpTask httpTask = (HttpTask)configuration;
            this.mapping = httpTask.getMapping();
        } else {
            this.mapping = new MappingDescription[0];
        }
        String contentType = this.getHeaderAsString("Content-Type");
        Charset charset = StandardCharsets.UTF_8;
        if (contentType != null) {
            int idx = contentType.indexOf(59);
            if (idx >= 0) {
                int charsetStartIdx = contentType.indexOf("charset=", idx) + 8;
                if (charsetStartIdx >= 0) {
                    int charsetStopIdx = contentType.charAt(charsetStartIdx) == '\"' ? contentType.indexOf(34, ++charsetStartIdx) : contentType.indexOf(58, charsetStartIdx);
                    if (charsetStopIdx < 0) {
                        charsetStopIdx = contentType.length();
                    }
                    try {
                        charset = Charset.forName(contentType.substring(charsetStartIdx, charsetStopIdx));
                    }
                    catch (Exception e) {
                        LOG.error("Unable to determine the charset for content type {}. Using UTF-8", (Object)contentType, (Object)e);
                    }
                }
                contentType = contentType.substring(0, idx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Determined Content-Type to be {}", (Object)contentType);
            }
        }
        this.rawContentType = contentType == null || contentType.isEmpty() ? null : contentType.toLowerCase();
        this.charset = charset;
    }

    public MappingDescription[] getMapping() {
        return this.mapping;
    }

    public String getRawContentType() {
        return this.rawContentType;
    }

    public BufferedReader getReader() {
        InputStream is = this.getInputStream();
        if (is == null) {
            is = new ByteArrayInputStream(this.getBytes());
        }
        return new BufferedReader(new InputStreamReader(is, this.charset));
    }
}

