/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiMap<T> {
    private Map<String, Set<T>> map = new ConcurrentHashMap<String, Set<T>>();

    public synchronized void put(String key, T value) {
        Set<T> values = this.map.get(key);
        if (values == null) {
            values = new HashSet<T>();
            this.map.put(key, values);
        }
        values.add(value);
    }

    public synchronized Set<T> get(String key) {
        return this.map.getOrDefault(key, Collections.emptySet());
    }

    public synchronized void remove(String key, T value) {
        Set<T> values = this.map.get(key);
        values.remove(value);
        if (values.isEmpty()) {
            this.map.remove(key);
        }
    }

    public synchronized Set<String> keySet() {
        return this.map.keySet();
    }

    public void remove(T toRemove) {
        HashSet<String> keys = new HashSet<String>(this.map.keySet());
        for (String key : keys) {
            this.remove(key, toRemove);
        }
    }

    public void clear() {
        this.map.clear();
    }
}

