/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer.local;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.aries.rsa.topologymanager.importer.local.ListenerHookImpl;
import org.apache.aries.rsa.topologymanager.importer.local.RSFindHook;
import org.apache.aries.rsa.topologymanager.importer.local.ReferenceCounter;
import org.apache.aries.rsa.topologymanager.importer.local.ServiceInterestListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointListenerManager
implements ServiceInterestListener {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointListenerManager.class);
    private final BundleContext bctx;
    private volatile ServiceRegistration<?> serviceRegistration;
    private final List<String> filters = new ArrayList<String>();
    private final EndpointEventListener endpointListener;
    private final ListenerHookImpl listenerHook;
    private RSFindHook findHook;
    private final ReferenceCounter<String> importInterestsCounter = new ReferenceCounter();

    public EndpointListenerManager(BundleContext bc, EndpointEventListener endpointListener) {
        this.bctx = bc;
        this.endpointListener = endpointListener;
        this.listenerHook = new ListenerHookImpl(bc, this);
        this.findHook = new RSFindHook(bc, this);
    }

    public void start() {
        EndpointListenerAdapter endpointListenerAdapter = new EndpointListenerAdapter();
        String[] ifAr = new String[]{EndpointListener.class.getName(), EndpointEventListener.class.getName()};
        this.serviceRegistration = this.bctx.registerService(ifAr, (Object)endpointListenerAdapter, this.getEELProperties());
        this.bctx.registerService(ListenerHook.class, (Object)this.listenerHook, null);
        this.bctx.registerService(FindHook.class, (Object)this.findHook, null);
    }

    public void stop() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extendScope(String filter) {
        if (filter == null) {
            return;
        }
        LOG.debug("EndpointListener: extending scope by {}", (Object)filter);
        List<String> list = this.filters;
        synchronized (list) {
            this.filters.add(filter);
        }
        this.updateRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reduceScope(String filter) {
        if (filter == null) {
            return;
        }
        LOG.debug("EndpointListener: reducing scope by {}", (Object)filter);
        List<String> list = this.filters;
        synchronized (list) {
            this.filters.remove(filter);
        }
        this.updateRegistration();
    }

    private Dictionary<String, Object> getEELProperties() {
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        ((Dictionary)p).put("endpoint.listener.scope", this.copyFilters());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> copyFilters() {
        List<String> list = this.filters;
        synchronized (list) {
            return new ArrayList<String>(this.filters);
        }
    }

    private void updateRegistration() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.setProperties(this.getEELProperties());
        }
    }

    @Override
    public void addServiceInterest(String filter) {
        if (this.importInterestsCounter.add(filter) == 1) {
            this.extendScope(filter);
        }
    }

    @Override
    public void removeServiceInterest(String filter) {
        if (this.importInterestsCounter.remove(filter) == 0) {
            LOG.debug("last reference to import interest is gone -> removing interest filter: {}", (Object)filter);
            this.reduceScope(filter);
        }
    }

    private final class EndpointListenerAdapter
    implements EndpointListener,
    EndpointEventListener {
        private EndpointListenerAdapter() {
        }

        public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
            EndpointEvent event = new EndpointEvent(2, endpoint);
            EndpointListenerManager.this.endpointListener.endpointChanged(event, matchedFilter);
        }

        public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
            EndpointEvent event = new EndpointEvent(1, endpoint);
            EndpointListenerManager.this.endpointListener.endpointChanged(event, matchedFilter);
        }

        public void endpointChanged(EndpointEvent event, String filter) {
            EndpointListenerManager.this.endpointListener.endpointChanged(event, filter);
        }
    }
}

