/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;

public class PropertyUtils {
    private static final Pattern PATTERN = Pattern.compile("\\$\\(([^\\)\\(\\$]+)\\)");

    public static Object getProperty(BundleContext context, Properties properties, String key) {
        Matcher matcher;
        if (key == null) {
            return null;
        }
        String builtKey = key;
        while ((matcher = PATTERN.matcher(builtKey)).find()) {
            Object property;
            int start = matcher.start();
            int end = matcher.end();
            StringBuilder builder = new StringBuilder();
            if (start > 0) {
                builder.append(key.substring(0, start));
            }
            if ((property = PropertyUtils.getProperty(context, properties, matcher.group(1))) == null) {
                return null;
            }
            builder.append(property);
            if (end < builtKey.length()) {
                builder.append(builtKey.substring(end, builtKey.length()));
            }
            builtKey = builder.toString();
        }
        Object value = null;
        value = properties == null ? null : properties.get(builtKey);
        if (value == null && (value = context.getProperty(builtKey)) == null) {
            value = System.getProperty(builtKey);
        }
        return value;
    }
}

