/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.rest;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;

public class RestLikeMappingReport {
    private Map<String, String> filtersMap;
    private Map<String, List<ServiceReference<?>>> referencesMap;
    private int unparsed;
    private String[] uriElements;
    private LinkedList<StackTraceElement> trace;
    private String method;
    private String className;

    public RestLikeMappingReport(String[] uriElements) {
        this.uriElements = uriElements;
        this.unparsed = this.uriElements.length;
        this.filtersMap = new HashMap<String, String>();
        this.referencesMap = new HashMap();
        this.trace = new LinkedList();
    }

    void reportReferences(String filter, List<ServiceReference<?>> references) {
        this.referencesMap.put(filter, references);
    }

    void reportFilter(int index, String filter) {
        this.filtersMap.put(this.uriElements[index], filter);
    }

    void reportMethod(String method) {
        this.method = method;
    }

    void reportImplementation(String className) {
        this.className = className;
    }

    void reportIndex(int index) {
        this.unparsed = index;
    }

    void reportError(Throwable throwable) {
        this.trace.addAll(Arrays.asList(throwable.getStackTrace()));
    }

    public void printStackTrace(PrintStream output) {
        for (int i = 0; i < this.trace.size(); ++i) {
            StackTraceElement element = this.trace.get(i);
            output.println(element.toString());
        }
    }

    public String method() {
        return this.method;
    }

    public String implementation() {
        return this.className;
    }

    public String unparsed() {
        StringBuilder builder = new StringBuilder();
        for (int i = this.unparsed + 1; i < this.uriElements.length; ++i) {
            if (this.uriElements[i].equals(this.method)) continue;
            builder.append(this.uriElements[i]);
            builder.append(i < this.uriElements.length - 1 ? "/" : "");
        }
        return builder.toString();
    }

    public ServiceReference<?>[] get(String key) {
        String filter = this.filtersMap.get(key);
        ServiceReference[] references = new ServiceReference[]{};
        if (filter != null) {
            List<ServiceReference<?>> referencesList = this.referencesMap.get(this.filtersMap.get(key));
            references = referencesList == null ? references : referencesList.toArray(references);
        }
        return references;
    }
}

