/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.tree;

import org.eclipse.sensinact.gateway.util.UriUtils;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNode;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathTree;
import org.eclipse.sensinact.gateway.util.tree.PathNode;
import org.eclipse.sensinact.gateway.util.tree.PathNodeFactory;

public class PathTree<P extends PathNode<P>> {
    protected final P root;
    protected final PathNodeFactory<P> factory;

    public PathTree(PathNodeFactory<P> factory) {
        this.factory = factory;
        this.root = this.factory.createRootNode();
    }

    public P add(String uri) {
        return this.add(uri, false);
    }

    public P add(String uri, boolean isPattern) {
        String[] uriElements = UriUtils.getUriElements(uri);
        StringBuilder builder = new StringBuilder();
        int length = uriElements == null ? 0 : uriElements.length;
        P node = null;
        for (int index = 0; index < length; ++index) {
            builder.append("/");
            node = length - index == 1 ? (P)this.add(builder.toString(), uriElements[index], isPattern) : (P)this.add(builder.toString(), uriElements[index], false);
            builder.append(uriElements[index]);
        }
        return node;
    }

    public P add(String uri, String uriElement) {
        return this.add(uri, uriElement, false);
    }

    public P add(String uri, String uriElement, boolean isPattern) {
        P current = this.get(uri);
        if (current != null) {
            current = ((PathNode)current).add(isPattern ? this.factory.createPatternNode(uriElement) : this.factory.createPathNode(uriElement));
        }
        return current;
    }

    public P getRoot() {
        return this.root;
    }

    public P get(String uri) {
        return ((PathNode)this.root).get(uri);
    }

    public P delete(String uri) {
        String parentUri = UriUtils.getParentUri(uri);
        Object parent = ((PathNode)this.root).get(parentUri);
        if (parent != null) {
            return ((PathNode)parent).remove(UriUtils.getLeaf(uri));
        }
        return null;
    }

    public String toString() {
        return ((PathNode)this.root).toString();
    }

    public <N extends ImmutablePathNode<N>, T extends ImmutablePathTree<N>> T immutable(Class<T> tc, Class<N> ic) {
        try {
            return (T)((ImmutablePathTree)tc.getConstructor(ic).newInstance(((PathNode)this.root).immutable(ic, null)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

