/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpTaskConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.KeyValuePairDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.NestedMappingDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.RootMappingDescription;

public class HttpTaskConfigurationDescription {
    public static final String NO_CERTIFICATE = "#NO_CERTIFICATE#";
    public static final String DEFAULT_CLIENT_SSL_CERTIFICATE = "#NO_CERTIFICATE#";
    public static final String DEFAULT_CLIENT_SSL_CERTIFICATE_PASSWORD = "#NO_CERTIFICATE#";
    public static final String DEFAULT_SERVER_SSL_CERTIFICATE = "#NO_CERTIFICATE#";
    public static final String DEFAULT_ACCEPT_TYPE = "text/plain";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_HTTP_METHOD = "GET";
    public static final String DEFAULT_PORT = "80";
    public static final String DEFAULT_PATH = "/";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 300000;
    public static final int DEFAULT_READ_TIMEOUT = 300000;
    public static final NestedMappingDescription[] DEFAULT_NESTED_MAPPING = new NestedMappingDescription[0];
    public static final RootMappingDescription[] DEFAULT_ROOT_MAPPING = new RootMappingDescription[0];
    @JsonProperty(value="acceptType")
    protected String acceptType;
    @JsonProperty(value="contentType")
    protected String contentType;
    @JsonProperty(value="httpMethod")
    protected String httpMethod;
    @JsonProperty(value="scheme")
    protected String scheme;
    @JsonProperty(value="host", required=true)
    protected String host;
    @JsonProperty(value="port")
    protected String port;
    @JsonProperty(value="path")
    protected String path;
    @JsonProperty(value="direct")
    protected boolean direct;
    @JsonProperty(value="clientSSLCertificate")
    protected String clientSSLCertificate;
    @JsonProperty(value="clientSSLCertificatePassword")
    protected String clientSSLCertificatePassword;
    @JsonProperty(value="serverSSLCertificate")
    protected String serverSSLCertificate;
    @JsonProperty(value="query")
    protected List<KeyValuePairDescription> query;
    @JsonProperty(value="headers")
    protected List<KeyValuePairDescription> headers;
    @JsonProperty(value="content")
    protected Class<? extends HttpTaskConfigurator> content;
    @JsonProperty(value="packet")
    protected Class<? extends HttpPacket> packet;
    @JsonProperty(value="readTimeout")
    protected int readTimeout;
    @JsonProperty(value="connectTimeout")
    protected int connectTimeout;
    @JsonProperty(value="nestedMapping")
    protected NestedMappingDescription[] nestedMapping;
    @JsonProperty(value="rootMapping")
    protected RootMappingDescription[] rootMapping;

    public static HttpTaskConfigurationDescription toDescription(HttpTaskConfiguration httpTaskConfiguration) {
        HttpTaskConfigurationDescription description = new HttpTaskConfigurationDescription();
        description.setAcceptType(httpTaskConfiguration.acceptType());
        description.setClientSSLCertificate(httpTaskConfiguration.clientSSLCertificate());
        description.setClientSSLCertificatePassword(httpTaskConfiguration.clientSSLCertificatePassword());
        description.setContent(httpTaskConfiguration.content());
        description.setContentType(httpTaskConfiguration.contentType());
        description.setDirect(httpTaskConfiguration.direct());
        description.setHeaders(KeyValuePairDescription.toDescription(httpTaskConfiguration.headers()));
        description.setHost(httpTaskConfiguration.host());
        description.setHttpMethod(httpTaskConfiguration.httpMethod());
        description.setPacket(httpTaskConfiguration.packet());
        description.setPath(httpTaskConfiguration.path());
        description.setPort(httpTaskConfiguration.port());
        description.setQuery(KeyValuePairDescription.toDescription(httpTaskConfiguration.query()));
        description.setScheme(httpTaskConfiguration.scheme());
        description.setServerSSLCertificate(httpTaskConfiguration.serverSSLCertificate());
        description.setConnectTimeout(httpTaskConfiguration.connectTimeout());
        description.setReadTimeout(httpTaskConfiguration.readTimeout());
        return description;
    }

    public HttpTaskConfigurationDescription() {
    }

    public HttpTaskConfigurationDescription(String acceptType, String contentType, String httpMethod, String scheme, String host, String port, String path, boolean direct, String clientSSLCertificate, String clientSSLCertificatePassword, String serverSSLCertificate, List<KeyValuePairDescription> query, List<KeyValuePairDescription> headers, Class<? extends HttpTaskConfigurator> content, Class<? extends HttpPacket> packet, int readTimeout, int connectTimeout, RootMappingDescription[] rootMapping, NestedMappingDescription[] nestedMapping) {
        this.acceptType = acceptType;
        this.contentType = contentType;
        this.httpMethod = httpMethod;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.direct = direct;
        this.clientSSLCertificate = clientSSLCertificate;
        this.clientSSLCertificatePassword = clientSSLCertificatePassword;
        this.serverSSLCertificate = serverSSLCertificate;
        if (query != null) {
            this.query = Collections.unmodifiableList(query);
        }
        if (headers != null) {
            this.headers = Collections.unmodifiableList(headers);
        }
        this.content = content;
        this.packet = packet;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.nestedMapping = nestedMapping;
        this.rootMapping = rootMapping;
    }

    public String getAcceptType() {
        if (this.acceptType == null) {
            return "text/plain";
        }
        return this.acceptType;
    }

    public void setAcceptType(String acceptType) {
        this.acceptType = acceptType;
    }

    public String getContentType() {
        if (this.contentType == null) {
            return "text/plain";
        }
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getHttpMethod() {
        if (this.httpMethod == null) {
            return DEFAULT_HTTP_METHOD;
        }
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getScheme() {
        if (this.scheme == null) {
            return DEFAULT_SCHEME;
        }
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        if (this.port == null) {
            return DEFAULT_PORT;
        }
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPath() {
        if (this.path == null) {
            return DEFAULT_PATH;
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public String getClientSSLCertificate() {
        if (this.clientSSLCertificate == null) {
            return "#NO_CERTIFICATE#";
        }
        return this.clientSSLCertificate;
    }

    public void setClientSSLCertificate(String clientSSLCertificate) {
        this.clientSSLCertificate = clientSSLCertificate;
    }

    public String getClientSSLCertificatePassword() {
        if (this.clientSSLCertificatePassword == null) {
            return "#NO_CERTIFICATE#";
        }
        return this.clientSSLCertificatePassword;
    }

    public void setClientSSLCertificatePassword(String clientSSLCertificatePassword) {
        this.clientSSLCertificatePassword = clientSSLCertificatePassword;
    }

    public String getServerSSLCertificate() {
        if (this.serverSSLCertificate == null) {
            return "#NO_CERTIFICATE#";
        }
        return this.serverSSLCertificate;
    }

    public void setServerSSLCertificate(String serverSSLCertificate) {
        this.serverSSLCertificate = serverSSLCertificate;
    }

    public List<KeyValuePairDescription> getQuery() {
        if (this.query == null) {
            return Collections.emptyList();
        }
        return this.query;
    }

    public void setQuery(List<KeyValuePairDescription> query) {
        if (query != null) {
            this.query = Collections.unmodifiableList(query);
        }
    }

    public List<KeyValuePairDescription> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return this.headers;
    }

    public void setHeaders(List<KeyValuePairDescription> headers) {
        if (headers != null) {
            this.headers = Collections.unmodifiableList(headers);
        }
    }

    public Class<? extends HttpTaskConfigurator> getContent() {
        if (this.content == null) {
            return HttpTaskConfigurator.class;
        }
        return this.content;
    }

    public void setContent(Class<? extends HttpTaskConfigurator> content) {
        this.content = content;
    }

    public Class<? extends HttpPacket> getPacket() {
        if (this.packet == null) {
            return HttpPacket.class;
        }
        return this.packet;
    }

    public void setPacket(Class<? extends HttpPacket> packet) {
        this.packet = packet;
    }

    public int getReadTimeout() {
        if (this.readTimeout == 0) {
            return 300000;
        }
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        if (this.connectTimeout == 0) {
            return 300000;
        }
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public NestedMappingDescription[] getNestedMapping() {
        if (this.nestedMapping == null) {
            return DEFAULT_NESTED_MAPPING;
        }
        return this.nestedMapping;
    }

    public void setNestedMapping(NestedMappingDescription[] nestedMapping) {
        this.nestedMapping = nestedMapping;
    }

    public RootMappingDescription[] getRootMapping() {
        if (this.rootMapping == null) {
            return DEFAULT_ROOT_MAPPING;
        }
        return this.rootMapping;
    }

    public void setMapping(RootMappingDescription[] rootMapping) {
        this.rootMapping = rootMapping;
    }
}

