/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.RecurrentHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTaskConfigurationDescription;

public class RecurrentHttpTaskDescription {
    static final long DEFAULT_DELAY = 1000L;
    static final long DEFAULT_PERIOD = 60000L;
    static final long DEFAULT_TIMEOUT = -1L;
    @JsonProperty(value="command")
    private Task.CommandType command;
    @JsonProperty(value="configuration")
    private HttpTaskConfigurationDescription configuration;
    @JsonProperty(value="period")
    private long period;
    @JsonProperty(value="delay")
    private long delay;
    @JsonProperty(value="timeout")
    private long timeout;

    public static RecurrentHttpTaskDescription toDescription(RecurrentHttpTask recurrentHttpTask) {
        RecurrentHttpTaskDescription description = new RecurrentHttpTaskDescription();
        description.setCommand(recurrentHttpTask.command());
        description.setConfiguration(HttpTaskConfigurationDescription.toDescription(recurrentHttpTask.recurrence()));
        description.setDelay(recurrentHttpTask.delay());
        description.setPeriod(recurrentHttpTask.period());
        description.setTimeout(recurrentHttpTask.timeout());
        return description;
    }

    public RecurrentHttpTaskDescription() {
    }

    public RecurrentHttpTaskDescription(Task.CommandType command, HttpTaskConfigurationDescription configuration, long period, long delay, long timeout) {
        this.command = command;
        this.configuration = configuration;
        this.period = period;
        this.delay = delay;
        this.timeout = timeout;
    }

    public Task.CommandType getCommand() {
        if (this.command == null) {
            return Task.CommandType.GET;
        }
        return this.command;
    }

    public void setCommand(Task.CommandType command) {
        this.command = command;
    }

    public HttpTaskConfigurationDescription getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HttpTaskConfigurationDescription configuration) {
        this.configuration = configuration;
    }

    public long getPeriod() {
        if (this.period <= 0L) {
            return 60000L;
        }
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getDelay() {
        if (this.delay <= 0L) {
            return 1000L;
        }
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getTimeout() {
        if (this.timeout <= 0L) {
            return -1L;
        }
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

