/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.security.signature.internal.CryptographicUtils;
import org.eclipse.sensinact.gateway.security.signature.internal.SignedBundleManifest;
import org.eclipse.sensinact.gateway.util.IOUtils;

public class ManifestChecker {
    private ManifestChecker() {
    }

    public static byte[] getNextSection(byte[] fileData, int offset) {
        int nextSectionLength = ManifestChecker.getNextSectionLength(fileData, offset);
        byte[] newSectionData = new byte[nextSectionLength];
        if (nextSectionLength != 0) {
            System.arraycopy(fileData, offset, newSectionData, 0, nextSectionLength);
        }
        return newSectionData;
    }

    private static int getNextSectionLength(byte[] rawManifestData, int offset) {
        int startOfNext = 0;
        int length = 0;
        boolean found = false;
        if (rawManifestData != null) {
            int k = rawManifestData.length;
            boolean flag = true;
            block4: for (int j = offset; j < k && !found; ++j) {
                byte byte0 = rawManifestData[j];
                switch (byte0) {
                    case 13: {
                        if (j < k && rawManifestData[j + 1] == 10) {
                            ++j;
                        }
                        if (flag || j == k - 1) {
                            startOfNext = j + 1;
                            found = true;
                            length = startOfNext - offset;
                        }
                        flag = true;
                        continue block4;
                    }
                    case 10: {
                        if (flag || j == k - 1) {
                            startOfNext = j + 1;
                            found = true;
                            length = startOfNext - offset;
                        }
                        flag = true;
                        continue block4;
                    }
                    default: {
                        flag = false;
                    }
                }
            }
        }
        if (!found) {
            length = startOfNext - offset;
        }
        if (length < 0) {
            length = 0;
        }
        return length;
    }

    public static Map<String, String> extractEntryHashes(Mediator mediator, InputStream iStream, CryptographicUtils cryptoUtils, String hashAlgo) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        byte[] currentEntryData;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        byte[] fileData = IOUtils.read((InputStream)iStream);
        String shaDigestType = null;
        String shaDigestMfMain = null;
        if ("SHA-1".equals(hashAlgo)) {
            shaDigestType = "SHA1-Digest";
            shaDigestMfMain = "SHA1-Digest-Manifest-Main-Attributes";
        } else if ("SHA-256".equals(hashAlgo)) {
            shaDigestType = "SHA-256-Digest";
            shaDigestMfMain = "SHA-256-Digest-Manifest-Main-Attributes";
        } else {
            shaDigestType = hashAlgo + "-Digest";
            shaDigestMfMain = hashAlgo + "-Digest-Manifest-Main-Attributes";
        }
        byte[] mfMainAttributes = SignedBundleManifest.getManifestMainAttributesAsBytes(fileData);
        String mfMainAttributesHash = cryptoUtils.getHashValue(mfMainAttributes, shaDigestType);
        dataMap.put(shaDigestMfMain, mfMainAttributesHash);
        int offset = mfMainAttributes.length;
        while ((currentEntryData = ManifestChecker.getNextSection(fileData, offset)) != null && currentEntryData.length > 0) {
            String entryName = ManifestChecker.getEntryName(currentEntryData);
            String entryHash = cryptoUtils.getHashValue(currentEntryData, shaDigestType);
            dataMap.put(entryName, entryHash);
            offset += currentEntryData.length;
        }
        return dataMap;
    }

    protected static String getEntryHash(Attributes atts) {
        Iterator<Map.Entry<Object, Object>> iter;
        String entryHash = "";
        if (atts != null && (iter = atts.entrySet().iterator()).hasNext()) {
            entryHash = (String)iter.next().getValue();
        }
        return entryHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEntryName(byte[] currentEntryData) throws IOException {
        String entryName = "";
        String nameHeader = "Name: ";
        BufferedReader bReader = null;
        try {
            String line;
            bReader = new BufferedReader(new InputStreamReader(ManifestChecker.removeShortLines(new ByteArrayInputStream(currentEntryData))));
            boolean nameFound = false;
            while (!nameFound && (line = bReader.readLine()) != null) {
                if (!line.startsWith(nameHeader)) continue;
                entryName = line.substring(nameHeader.length());
                nameFound = true;
            }
        }
        finally {
            if (bReader != null) {
                try {
                    bReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return entryName;
    }

    public static InputStream removeShortLines(InputStream iStream) throws IOException {
        String line;
        BufferedReader bReader = new BufferedReader(new InputStreamReader(iStream));
        int shortlineLength = 70;
        StringBuffer longLineData = new StringBuffer();
        while ((line = bReader.readLine()) != null) {
            longLineData = ManifestChecker.addLine(bReader, longLineData, line, shortlineLength);
        }
        return new ByteArrayInputStream(longLineData.toString().getBytes());
    }

    public static StringBuffer addLine(BufferedReader bReader, StringBuffer longLineData, String line, int shortlineLength) throws IOException {
        String currentLine = line;
        if (currentLine != null) {
            if (currentLine.length() < shortlineLength) {
                longLineData.append(currentLine).append("\r\n");
            } else if (currentLine.length() == shortlineLength) {
                longLineData.append(currentLine);
                while ((currentLine = bReader.readLine()).startsWith(" ")) {
                    longLineData.append(currentLine.substring(1));
                }
                longLineData.append("\r\n");
                ManifestChecker.addLine(bReader, longLineData, currentLine, shortlineLength);
            }
        }
        return longLineData;
    }
}

