/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFile {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureFile.class);
    private Attributes mainAttributes = null;
    private Map<String, Attributes> resourcesEntries = null;
    private byte[] data;
    private String hashHeader = null;
    private String hashAlgo = null;
    private Mediator mediator;
    private static final String SHA1_ALGO = "SHA-1";
    private static final String SHA1_DIGEST_MF = "SHA1-Digest-Manifest";
    private static final String SHA256_ALGO = "SHA-256";
    private static final String SHA256_DIGEST_MF = "SHA-256-Digest-Manifest";

    SignatureFile(Mediator mediator, URL url) throws IOException {
        this.mediator = mediator;
        this.data = IOUtils.read((InputStream)url.openStream());
        ByteArrayInputStream input = new ByteArrayInputStream(this.data);
        this.mainAttributes = this.getMainAttributes(input);
        this.initAlgo();
        input.reset();
        this.resourcesEntries = this.getEntries(input);
    }

    public final Attributes getMainAttributes() {
        if (this.mainAttributes == null) {
            LOG.warn("SignatureFile main Attributes not initialized");
        }
        return this.mainAttributes;
    }

    protected final Attributes getMainAttributes(InputStream iStream) throws IOException {
        return new Manifest(iStream).getMainAttributes();
    }

    public final Map<String, Attributes> getEntries() {
        if (this.resourcesEntries == null && LOG.isWarnEnabled()) {
            LOG.warn("SignatureFile entries not initialized");
        }
        return this.resourcesEntries;
    }

    protected final Map<String, Attributes> getEntries(InputStream iStream) throws IOException {
        return new Manifest(iStream).getEntries();
    }

    private void initAlgo() {
        if (this.mainAttributes.getValue(SHA1_DIGEST_MF) == null) {
            this.hashAlgo = SHA256_ALGO;
            this.hashHeader = SHA256_DIGEST_MF;
        } else {
            this.hashAlgo = SHA1_ALGO;
            this.hashHeader = SHA1_DIGEST_MF;
        }
    }

    public String getManifestHash() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for Manifest hash header [%s]", (Object)this.hashHeader);
        }
        return this.mainAttributes.getValue(this.hashHeader);
    }

    public String getHashAlgo() {
        return this.hashAlgo;
    }

    public final byte[] getBytes() throws IOException {
        byte[] dataCopy = new byte[this.data.length];
        System.arraycopy(this.data, 0, dataCopy, 0, this.data.length);
        return dataCopy;
    }

    public String toString() {
        String stringValue = "";
        try {
            stringValue = new String(this.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringValue;
    }

    public void show() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SignatureFile.show");
        }
        for (Map.Entry<Object, Object> entry : this.mainAttributes.entrySet()) {
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(entry.getKey() + ", " + entry.getValue());
        }
        for (Map.Entry<String, Attributes> entr2 : this.resourcesEntries.entrySet()) {
            String value = (String)entr2.getValue().entrySet().iterator().next().getValue();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(entr2.getKey() + ", " + value);
        }
    }
}

