/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.perm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.sensinact.gateway.core.security.perm.CodeBaseCondition;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class StrictCodeBaseCondition
implements Condition {
    private static final String CONDITION_TYPE = "org.eclipse.sensinact.gateway.core.security.perm.StrictCodeBaseCondition";
    private static final String STRICT_CODEBASE_SOURCES_TYPE = "org.eclipse.sensinact.gateway.core.security.perm.StrictCodeBaseCondition$1";
    private static CodeBaseCondition.CodeBaseSources _sources = null;
    private Bundle bundle;
    private ConditionInfo info;

    public static Condition getCondition(Bundle bundle, ConditionInfo info) {
        if (!CONDITION_TYPE.equals(info.getType())) {
            throw new IllegalArgumentException("ConditionInfo must be of type \"org.eclipse.sensinact.gateway.core.security.perm.StrictCodeBaseCondition\"");
        }
        String[] args = info.getArgs();
        if (args.length != 1 && args.length != 2) {
            throw new IllegalArgumentException("Illegal number of args: " + args.length);
        }
        final Condition complies = info.getArgs().length == 2 && "!".equals(info.getArgs()[1]) ? Condition.FALSE : Condition.TRUE;
        Condition uncomplies = complies.equals(Condition.FALSE) ? Condition.TRUE : Condition.FALSE;
        final CodeBaseCondition.ConditionWrapper pod = new CodeBaseCondition.ConditionWrapper();
        pod.c = uncomplies;
        if (_sources == null) {
            String[] s = info.getArgs()[0].split("\\\\,");
            _sources = new CodeBaseCondition.CodeBaseSources((List)Arrays.asList(s), CONDITION_TYPE, STRICT_CODEBASE_SOURCES_TYPE){};
        }
        _sources.check(STRICT_CODEBASE_SOURCES_TYPE);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                int length;
                StackTraceElement[] stacktraceElements = Thread.currentThread().getStackTrace();
                int n = length = stacktraceElements == null ? 0 : stacktraceElements.length;
                for (int index = 0; index < length; ++index) {
                    StackTraceElement e = stacktraceElements[index];
                    if (!_sources.getCache().contains(e.getClassName())) continue;
                    pod.c = complies;
                    break;
                }
                return null;
            }
        });
        return pod.c;
    }

    private StrictCodeBaseCondition() {
    }

    public StrictCodeBaseCondition(Bundle bundle, ConditionInfo info) {
        this.bundle = bundle;
        this.info = info;
    }

    public boolean isPostponed() {
        return false;
    }

    public boolean isSatisfied() {
        return StrictCodeBaseCondition.getCondition(this.bundle, this.info).isSatisfied();
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isSatisfied(Condition[] conditions, Dictionary<Object, Object> context) {
        if (conditions != null && conditions.length > 0) {
            for (Condition condition : conditions) {
                if (condition.isSatisfied()) continue;
                return false;
            }
        }
        return true;
    }
}

