/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.TypeDefinition;
import org.eclipse.sensinact.gateway.generic.parser.XmlElement;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

@XmlElement(tag="value", field="value")
public class ValueDefinition<C>
extends XmlModelParsingContext {
    private static final Logger LOG = LoggerFactory.getLogger(ValueDefinition.class);
    protected Object value;
    protected TypeDefinition<C> typeDefinition;

    public ValueDefinition(Mediator mediator, Attributes atts, TypeDefinition<C> typeDefinition) {
        super(mediator, atts);
        this.typeDefinition = typeDefinition;
    }

    public void setValue(String value) {
        C type = this.typeDefinition.getType();
        if (Class.class.isAssignableFrom(type.getClass())) {
            try {
                this.value = CastUtils.cast((Class)((Class)type), (Object)value);
            }
            catch (ClassCastException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.value = value;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public TypeDefinition<?> getTypeDefinition() {
        return this.typeDefinition;
    }
}

