/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.lang.reflect.Array;
import java.util.ServiceLoader;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.DefaultConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.Expression;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public interface ConstraintFactory {
    public boolean handle(String var1);

    public Constraint newInstance(String var1, Class<?> var2, Object var3, boolean var4) throws InvalidConstraintDefinitionException;

    public static final class Loader {
        public static Constraint load(ClassLoader classloader, String constraint, Class<?> referenceClass, Object reference, boolean complement) throws InvalidConstraintDefinitionException {
            ConstraintFactory factory2 = new DefaultConstraintFactory();
            if (!factory2.handle(constraint)) {
                factory2 = null;
                ServiceLoader<ConstraintFactory> serviceLoader = ServiceLoader.load(ConstraintFactory.class, classloader);
                for (ConstraintFactory factory2 : serviceLoader) {
                    if (factory2.handle(constraint)) break;
                    factory2 = null;
                }
            }
            if (factory2 == null) {
                throw new InvalidConstraintDefinitionException("No factory found");
            }
            return factory2.newInstance(constraint, referenceClass, reference, complement);
        }

        public static Constraint load(ClassLoader classloader, Object constraint) throws InvalidConstraintDefinitionException {
            if (constraint == null) {
                throw new InvalidConstraintDefinitionException("Invalid constraint definition : null");
            }
            if (Constraint.class.isAssignableFrom(constraint.getClass())) {
                return (Constraint)constraint;
            }
            if (JSONObject.class.isAssignableFrom(constraint.getClass())) {
                return Loader.load(classloader, (JSONObject)constraint);
            }
            if (JSONArray.class.isAssignableFrom(constraint.getClass())) {
                return Loader.load(classloader, (JSONArray)constraint);
            }
            throw new InvalidConstraintDefinitionException("Unable to cast " + constraint.getClass() + " into a constraint");
        }

        public static Constraint load(ClassLoader classloader, JSONObject constraint) throws InvalidConstraintDefinitionException {
            String operator;
            Object operand = null;
            String type = constraint.optString("type");
            Class clazz = null;
            if (type != null && type.length() > 0) {
                try {
                    clazz = CastUtils.loadClass((ClassLoader)classloader, (String)type);
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidConstraintDefinitionException("Invalid type :" + type);
                }
            }
            if ((operator = constraint.optString("operator")) == null || operator.length() == 0) {
                throw new InvalidConstraintDefinitionException("Null operator");
            }
            Object[] operandObject = constraint.opt("operand");
            if (operandObject != null) {
                if (JSONArray.class.isAssignableFrom(operandObject.getClass())) {
                    JSONArray operandArray = (JSONArray)operandObject;
                    int length = operandArray.length();
                    switch (length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            operand = operandArray.get(0);
                            break;
                        }
                        default: {
                            operand = new Object[length];
                            for (int index = 0; index < length; ++index) {
                                Array.set(operand, index, operandArray.get(index));
                            }
                        }
                    }
                } else {
                    operand = operandObject;
                }
            }
            boolean complement = (Boolean)CastUtils.getObjectFromJSON(Boolean.TYPE, (Object)constraint.opt("complement"));
            return Loader.load(classloader, operator, clazz, operand, complement);
        }

        public static Constraint load(ClassLoader classloader, JSONArray constraint) throws InvalidConstraintDefinitionException {
            if (constraint == null) {
                throw new InvalidConstraintDefinitionException("Invalid constraint definition : null");
            }
            Expression.LogicalOperator logicalOperator = null;
            try {
                logicalOperator = Expression.LogicalOperator.valueOf(constraint.getString(0));
                constraint.remove(0);
            }
            catch (Exception e) {
                JSONObject uniqueConstraint = null;
                if (constraint.length() == 1 && !JSONObject.NULL.equals(uniqueConstraint = constraint.optJSONObject(0))) {
                    return Loader.load(classloader, uniqueConstraint);
                }
                logicalOperator = Expression.LogicalOperator.AND;
            }
            return Loader.load(classloader, constraint, logicalOperator);
        }

        public static Constraint load(ClassLoader classloader, JSONArray constraint, Expression.LogicalOperator logicalOperator) throws InvalidConstraintDefinitionException {
            int length = constraint == null ? 0 : constraint.length();
            Expression expression = new Expression(logicalOperator);
            for (int index = 0; index < length; ++index) {
                Object embeddedConstraint = constraint.get(index);
                if (JSONObject.class.isAssignableFrom(embeddedConstraint.getClass())) {
                    expression.add(Loader.load(classloader, (JSONObject)embeddedConstraint));
                    continue;
                }
                if (JSONArray.class.isAssignableFrom(embeddedConstraint.getClass())) {
                    expression.add(Loader.load(classloader, (JSONArray)embeddedConstraint));
                    continue;
                }
                throw new InvalidConstraintDefinitionException("Invalid constraint definition : " + embeddedConstraint);
            }
            return expression;
        }
    }
}

