/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import java.util.HashMap;
import java.util.List;
import org.eclipse.sensinact.gateway.core.security.dao.AbstractImmutableSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.dao.ObjectDAO;
import org.eclipse.sensinact.gateway.core.security.entity.AuthenticatedAccessLevelEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;

public class AuthenticatedAccessLevelDAO
extends AbstractImmutableSnaDAO<AuthenticatedAccessLevelEntity> {
    private ObjectDAO objectDAO;

    public AuthenticatedAccessLevelDAO(DataStoreService dataStoreService) throws DAOException {
        super(AuthenticatedAccessLevelEntity.class, dataStoreService);
        this.objectDAO = new ObjectDAO(dataStoreService);
    }

    protected AuthenticatedAccessLevelEntity find(final long objectIdentifier, final String publicKey) throws DAOException, DataStoreException {
        List userAccessLevelEntities = super.select(new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("UOID", objectIdentifier);
                this.put("PUBLIC_KEY", publicKey);
            }
        });
        if (userAccessLevelEntities.size() != 1) {
            return null;
        }
        return (AuthenticatedAccessLevelEntity)userAccessLevelEntities.get(0);
    }

    protected AuthenticatedAccessLevelEntity find(final long objectIdentifier, final long userIdentifier) throws DAOException, DataStoreException {
        List userAccessLevelEntities = super.select(new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("UOID", objectIdentifier);
                this.put("UID", userIdentifier);
            }
        });
        if (userAccessLevelEntities.size() != 1) {
            return null;
        }
        return (AuthenticatedAccessLevelEntity)userAccessLevelEntities.get(0);
    }

    public AuthenticatedAccessLevelEntity find(String path, String publicKey) throws DAOException, DataStoreException {
        ObjectEntity objectEntity = null;
        List<ObjectEntity> objectEntities = this.objectDAO.find(path);
        if (objectEntities.size() <= 0) {
            throw new DAOException(String.format("Unknown element at '%s'", path));
        }
        objectEntity = objectEntities.get(0);
        return this.find(objectEntity.getIdentifier(), publicKey);
    }

    public AuthenticatedAccessLevelEntity find(String path, long identifier) throws DAOException, DataStoreException {
        ObjectEntity objectEntity = null;
        List<ObjectEntity> objectEntities = this.objectDAO.find(path);
        if (objectEntities.size() <= 0) {
            throw new DAOException(String.format("Unknown element at '%s'", path));
        }
        objectEntity = objectEntities.get(0);
        return this.find(objectEntity.getIdentifier(), identifier);
    }
}

