/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.sensinact.gateway.core.security.dao.AbstractMutableSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.AbstractSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDAO
extends AbstractMutableSnaDAO<ObjectEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectDAO.class);

    public ObjectDAO(DataStoreService dataStoreService) throws DAOException {
        this(dataStoreService, FrameworkUtil.getBundle(ObjectDAO.class).getResource("script/getObjectFromPath.sql"));
    }

    public ObjectDAO(DataStoreService dataStoreService, URL url) throws DAOException {
        super(ObjectEntity.class, dataStoreService);
        super.registerUserDefinedSelectStatement("getObjectFromPath", new AbstractSnaDAO.UserDefinedSelectStatement(this, url));
    }

    public List<ObjectEntity> find(String path) throws DAOException, DataStoreException {
        return this.find(path, false);
    }

    public List<ObjectEntity> find(String path, boolean exact) throws DAOException, DataStoreException {
        ArrayList<ObjectEntity> filtered = new ArrayList<ObjectEntity>();
        if (path == null) {
            return filtered;
        }
        List objectEntities = super.select("getObjectFromPath", new String[]{path});
        while (!objectEntities.isEmpty()) {
            String objectPath;
            String[] objectPathElements;
            ObjectEntity tmpEntity = (ObjectEntity)objectEntities.remove(0);
            if (tmpEntity == null) continue;
            if (!exact || path.equals(tmpEntity.getPath())) {
                filtered.add(tmpEntity);
                continue;
            }
            String[] uriElements = UriUtils.getUriElements((String)path);
            if (uriElements.length != (objectPathElements = (objectPath = tmpEntity.getPath()) != null ? UriUtils.getUriElements((String)objectPath.replace("[^/]+", "#ANY#")) : new String[]{}).length) continue;
            String lastSearched = uriElements[uriElements.length - 1];
            String lastFound = objectPathElements[uriElements.length - 1];
            try {
                if (!lastFound.equals("#ANY#") && !lastSearched.equals(lastFound) && !Pattern.matches(lastFound, lastSearched)) continue;
                filtered.add(tmpEntity);
            }
            catch (PatternSyntaxException e) {
                LOG.debug("exact path '%s' not found", (Object)path);
            }
        }
        return filtered;
    }

    public List<ObjectEntity> findChildren(long identifier) throws DAOException, DataStoreException {
        return super.select(Collections.singletonMap("PARENT", identifier));
    }
}

