/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.InvalidAttributeException;
import org.eclipse.sensinact.gateway.core.Metadata;
import org.eclipse.sensinact.gateway.core.MetadataBuilder;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttributeBuilder
implements Nameable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeBuilder.class);
    public static final String SEP = "_";
    public static final String PROPERTY_DEFAULT_PREFIX = "DEFAULT_";
    public static final String ATTRIBUTES_PROPERTY = "ATTRIBUTES";
    protected Class<?> type;
    protected Object value;
    protected Modifiable modifiable;
    protected boolean hidden;
    protected final Requirement[] requirementsArray;
    protected Deque<Requirement> requirementsList;
    private Deque<Constraint> constraintsList;
    private List<MetadataBuilder> metadataBuilders;
    public final String name;

    public static final AttributeBuilder[] getAttributeBuilders(LinkedList<Class<Resource>> list) {
        AttributeBuilder[] attributeBuilders = null;
        Iterator<Class<Resource>> iterator = list.descendingIterator();
        while (iterator.hasNext()) {
            Class<Resource> resourceInterface = iterator.next();
            try {
                attributeBuilders = AttributeBuilder.mergeAttributeBuilders((AttributeBuilder[])resourceInterface.getDeclaredField(ATTRIBUTES_PROPERTY).get(null), attributeBuilders);
            }
            catch (Exception e) {}
        }
        return attributeBuilders;
    }

    private static final AttributeBuilder[] mergeAttributeBuilders(AttributeBuilder[] current, AttributeBuilder[] inherited) {
        AttributeBuilder[] merged = null;
        if (current == null || current.length == 0) {
            if (inherited != null && inherited.length > 0) {
                merged = AttributeBuilder.clone(inherited, inherited.length);
            }
        } else if (inherited == null || inherited.length == 0) {
            if (current != null && current.length > 0) {
                merged = AttributeBuilder.clone(current, current.length);
            }
        } else {
            int delta = inherited.length;
            merged = AttributeBuilder.clone(inherited, current.length + delta);
            for (int index = 0; index < current.length; ++index) {
                merged[index + delta] = (AttributeBuilder)current[index].clone();
            }
        }
        return merged;
    }

    protected static final AttributeBuilder[] clone(AttributeBuilder[] builders, int length) {
        if (builders == null || length < 0) {
            return null;
        }
        AttributeBuilder[] clone = new AttributeBuilder[length];
        for (int index = 0; index < builders.length && index < length; ++index) {
            clone[index] = (AttributeBuilder)builders[index].clone();
        }
        return clone;
    }

    public AttributeBuilder(String name, Requirement[] requirementsArray) throws InvalidAttributeException {
        if (name == null) {
            throw new InvalidAttributeException("attribute name required");
        }
        this.requirementsArray = new Requirement[requirementsArray == null ? 0 : requirementsArray.length];
        if (this.requirementsArray.length > 0) {
            System.arraycopy(requirementsArray, 0, this.requirementsArray, 0, this.requirementsArray.length);
        }
        this.requirementsList = new LinkedList<Requirement>(Arrays.asList(this.requirementsArray));
        this.constraintsList = new LinkedList<Constraint>();
        this.metadataBuilders = new ArrayList<MetadataBuilder>();
        this.name = name;
    }

    private AttributeBuilder(String name, Requirement[] requirementsArray, Deque<Requirement> requirementsList, boolean hidden, Modifiable modifiable, Class<?> type, Object value) throws InvalidAttributeException {
        if (name == null) {
            throw new InvalidAttributeException("attribute name required");
        }
        this.requirementsArray = new Requirement[requirementsArray == null ? 0 : requirementsArray.length];
        if (this.requirementsArray.length > 0) {
            System.arraycopy(requirementsArray, 0, this.requirementsArray, 0, this.requirementsArray.length);
        }
        this.requirementsList = new LinkedList<Requirement>(requirementsList);
        this.constraintsList = new LinkedList<Constraint>();
        this.metadataBuilders = new ArrayList<MetadataBuilder>();
        this.name = name;
        this.hidden = hidden;
        this.modifiable = modifiable;
        this.type = type;
        this.value = value;
    }

    public void addMetadataBuilder(MetadataBuilder metadataBuilder) {
        this.metadataBuilders.add(metadataBuilder);
    }

    public void addMetadataBuilders(List<MetadataBuilder> metadataBuilder) {
        this.metadataBuilders.addAll(metadataBuilder);
    }

    public Object clone() {
        AttributeBuilder clone = new AttributeBuilder(this.name, this.requirementsArray, this.requirementsList, this.hidden, this.modifiable, this.type, this.value);
        Iterator<Constraint> iterator = this.constraintsList.iterator();
        while (iterator.hasNext()) {
            clone.addConstraint(iterator.next());
        }
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public AttributeBuilder type(Class<?> attributeType) {
        if (attributeType != null && this.updateRequirements(Requirement.TYPE)) {
            this.type = attributeType;
        }
        return this;
    }

    public AttributeBuilder value(Object value) {
        this.updateRequirements(Requirement.VALUE);
        this.value = value;
        return this;
    }

    public AttributeBuilder hidden(boolean hidden) {
        if (this.updateRequirements(Requirement.HIDDEN)) {
            this.hidden = hidden;
        }
        return this;
    }

    public AttributeBuilder modifiable(Modifiable modifiable) {
        if (this.updateRequirements(Requirement.MODIFIABLE)) {
            this.modifiable = modifiable;
        }
        return this;
    }

    public Attribute getAttribute(Mediator mediator, ResourceImpl resource, TypeConfig resourceTypeConfig) throws InvalidAttributeException {
        String constantName;
        if (resource == null) {
            return null;
        }
        String constantPrefix = this.name.toUpperCase() + SEP;
        for (Requirement requirement : this.requirementsArray) {
            constantName = constantPrefix + requirement.name();
            this.setRequirementValue(mediator, requirement, resourceTypeConfig, constantName, true);
        }
        while (this.requirementsList.size() > 0) {
            Requirement requirement;
            requirement = this.requirementsList.removeFirst();
            constantName = PROPERTY_DEFAULT_PREFIX + constantPrefix + requirement.name();
            this.setRequirementValue(mediator, requirement, resourceTypeConfig, constantName, false);
        }
        if (this.isComplete()) {
            try {
                Attribute attribute = new Attribute(mediator, resource, this.name, this.type, this.value, this.modifiable, this.hidden);
                if (!this.constraintsList.isEmpty()) {
                    attribute.addMetadata(new Metadata(mediator, "constraints", Constraint[].class, this.constraintsList.toArray(new Constraint[0]), Modifiable.FIXED));
                }
                if (!this.metadataBuilders.isEmpty()) {
                    Iterator<MetadataBuilder> iterator = this.metadataBuilders.iterator();
                    while (iterator.hasNext()) {
                        attribute.addMetadata(iterator.next().getMetadata());
                    }
                }
                return attribute;
            }
            catch (InvalidValueException e) {
                throw new InvalidAttributeException(e.getMessage(), e);
            }
        }
        throw new InvalidAttributeException(resource.getPath() + " Creating attribute '" + this.name + "' : missing requirements " + Arrays.toString(this.requirementsList.toArray()));
    }

    private void setRequirementValue(Mediator mediator, Requirement requirement, TypeConfig resourceTypeConfig, String constantName, boolean fromTop) {
        block3: {
            Object constant = resourceTypeConfig.getConstantValue(constantName, fromTop);
            if (constant != null) {
                try {
                    AttributeBuilder.class.getDeclaredField(requirement.name().toLowerCase()).set(this, constant);
                    this.updateRequirements(requirement);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean isComplete() {
        return this.requirementsList.isEmpty() && this.name != null && this.type != null;
    }

    private boolean updateRequirements(Requirement requirement) {
        return this.requirementsList.remove((Object)requirement);
    }

    public void addConstraint(Constraint constraint) {
        this.constraintsList.add(constraint);
    }

    public void addConstraints(List<Constraint> constraints) {
        this.constraintsList.addAll(constraints);
    }

    public static enum Requirement {
        HIDDEN,
        MODIFIABLE,
        VALUE,
        TYPE;

    }
}

