/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ModelElementProxy;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.UnaccessibleAccessMethod;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;

public class ResourceProxy
extends ModelElementProxy {
    protected final Map<String, AccessMethod<?, ?>> methods;

    ResourceProxy(Mediator mediator, ResourceImpl resource, List<MethodAccessibility> methodAccessibilities) {
        super(mediator, Resource.class, resource.getPath());
        int length;
        HashMap methods = new HashMap();
        AccessMethod.Type[] existingTypes = AccessMethod.Type.values();
        int n = length = existingTypes == null ? 0 : existingTypes.length;
        for (int index = 0; index < length; ++index) {
            AccessMethod<?, ?> method = null;
            method = resource.getAccessMethod(existingTypes[index]);
            if (method == null) continue;
            String name = existingTypes[index].name();
            if (methodAccessibilities.stream().filter(ma -> name.equals(ma.getName())).map(ma -> !ma.isAccessible()).findFirst().orElse(true).booleanValue()) {
                methods.put(existingTypes[index].name(), new UnaccessibleAccessMethod(mediator, super.getPath(), existingTypes[index]));
                continue;
            }
            methods.put(existingTypes[index].name(), method);
        }
        this.methods = Collections.unmodifiableMap(methods);
    }

    @Override
    public AccessMethod<?, ?> getAccessMethod(String type) {
        return this.methods.get(type);
    }
}

