/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.props.KeysCollection;
import org.eclipse.sensinact.gateway.core.message.AbstractSnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.message.SnaNotificationMessage;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessage;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONObject;

public abstract class SnaNotificationMessageImpl<S extends Enum<S> & KeysCollection>
extends AbstractSnaMessage<S>
implements SnaNotificationMessage<S> {
    protected SnaNotificationMessageImpl(String uri, S type) {
        super(uri, type);
    }

    @Override
    public void setNotification(JSONObject jsonObject) {
        if (JSONObject.NULL.equals(jsonObject)) {
            return;
        }
        super.putValue("notification", (Object)jsonObject);
    }

    @Override
    public JSONObject getNotification() {
        JSONObject jsonObject = (JSONObject)super.get("notification");
        return jsonObject;
    }

    public Object getNotification(String key) {
        Object value = null;
        JSONObject jsonObject = this.getNotification();
        if (jsonObject != null) {
            value = jsonObject.opt(key);
        }
        return value;
    }

    public <T> T getNotification(Class<T> type, String key) {
        return (T)CastUtils.cast(type, (Object)this.getNotification(key));
    }

    public static final class Builder {
        public static final <N extends SnaNotificationMessage<?>> N notification(Mediator mediator, SnaMessageSubType notificationType, String uri) {
            SnaNotificationMessageImpl notification = null;
            switch (notificationType.getSnaMessageType()) {
                case ERROR: {
                    break;
                }
                case LIFECYCLE: {
                    notification = new SnaLifecycleMessageImpl(uri, (SnaLifecycleMessage.Lifecycle)notificationType);
                    break;
                }
                case RESPONSE: {
                    break;
                }
                case UPDATE: {
                    notification = new SnaUpdateMessageImpl(uri, (SnaUpdateMessage.Update)notificationType);
                    break;
                }
                case REMOTE: {
                    notification = new SnaRemoteMessageImpl(uri, (SnaRemoteMessage.Remote)notificationType);
                    break;
                }
            }
            return (N)notification;
        }
    }
}

