/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AccessNode;
import org.eclipse.sensinact.gateway.core.security.AccessNodeImpl;
import org.eclipse.sensinact.gateway.core.security.AccessProfile;
import org.eclipse.sensinact.gateway.core.security.MethodAccess;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibilityImpl;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNode;
import org.eclipse.sensinact.gateway.util.tree.PathNodeList;

public final class ImmutableAccessNode
extends ImmutablePathNode<ImmutableAccessNode>
implements AccessNode {
    private final Map<AccessLevelOption, List<MethodAccessibility>> accesses;
    private final AccessProfile profile;

    public <A extends AccessNodeImpl<A>> ImmutableAccessNode(ImmutableAccessNode parent, String nodeName, boolean isPattern, PathNodeList<A> children, AccessProfile profile) {
        super((ImmutablePathNode)parent, nodeName, isPattern, children);
        this.accesses = this.withAccessProfile(profile);
        this.profile = profile;
    }

    @Override
    public AccessProfile getProfile() {
        return this.profile;
    }

    private Map<AccessLevelOption, List<MethodAccessibility>> withAccessProfile(AccessProfile profile) {
        int length;
        EnumMap accesses = new EnumMap(AccessLevelOption.class);
        if (profile == null) {
            return Collections.unmodifiableMap(accesses);
        }
        Set<MethodAccess> methodAccesses = profile.getMethodAccesses();
        if (methodAccesses.isEmpty()) {
            return Collections.unmodifiableMap(accesses);
        }
        int[] accessLevels = null;
        Iterator<AccessLevelOption> iterator = Arrays.asList(AccessLevelOption.values()).iterator();
        AccessMethod.Type[] types = AccessMethod.Type.values();
        accessLevels = new int[types.length];
        for (MethodAccess methodAccess : methodAccesses) {
            int level = methodAccess.getAccessLevel().getLevel();
            int ind = methodAccess.getMethod().ordinal();
            accessLevels[ind] = level;
        }
        int index = -1;
        int n = length = types == null ? 0 : types.length;
        while (iterator.hasNext()) {
            AccessLevelOption optionLevel = iterator.next();
            for (index = 0; index < length; ++index) {
                boolean accessibility = accessLevels[index] <= optionLevel.getAccessLevel().getLevel();
                ArrayList<MethodAccessibilityImpl> accessibilities = (ArrayList<MethodAccessibilityImpl>)accesses.get((Object)optionLevel);
                if (accessibilities == null) {
                    accessibilities = new ArrayList<MethodAccessibilityImpl>();
                    accesses.put(optionLevel, accessibilities);
                }
                MethodAccessibilityImpl methodAccessibilities = new MethodAccessibilityImpl(types[index], optionLevel, accessibility);
                accessibilities.add(methodAccessibilities);
            }
        }
        return Collections.unmodifiableMap(accesses);
    }

    @Override
    public List<MethodAccessibility> getAccessibleMethods(AccessLevelOption accessLevelOption) {
        ArrayList<MethodAccessibility> accesses = new ArrayList<MethodAccessibility>();
        AccessMethod.Type[] types = AccessMethod.Type.values();
        int length = types.length;
        for (int index = 0; index < length; ++index) {
            accesses.add(new MethodAccessibilityImpl(types[index], accessLevelOption, this.isAccessibleMethod(types[index], accessLevelOption)));
        }
        return accesses;
    }

    protected boolean isAccessibleMethod(AccessMethod.Type accessMethod, AccessLevelOption optionLevel) {
        boolean accessible = false;
        List methodAccesses = this.accesses == null ? Collections.emptyList() : Optional.ofNullable(this.accesses.get((Object)optionLevel)).orElse(Collections.emptyList());
        Optional<MethodAccessibility> found = methodAccesses.stream().filter(ma -> ma.getName().equals(accessMethod.name())).findFirst();
        accessible = found.isPresent() ? found.get().isAccessible() : (this.parent == null ? false : ((ImmutableAccessNode)this.parent).isAccessibleMethod(accessMethod, optionLevel));
        return accessible;
    }

    @Override
    public AccessLevelOption getAccessLevelOption(AccessMethod.Type method) {
        int length;
        AccessLevelOption[] accessLevelOptions = AccessLevelOption.values();
        int n = length = accessLevelOptions == null ? 0 : accessLevelOptions.length;
        for (int index = 0; index < length; ++index) {
            if (!this.isAccessibleMethod(method, accessLevelOptions[index])) continue;
            return accessLevelOptions[index];
        }
        return AccessLevelOption.OWNER;
    }
}

