/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.exception.ProcessorException;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.iface.ProcessorFormatIface;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.selector.SelectorIface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorExecutor {
    private final Map<String, ProcessorFormatIface> processors = new HashMap<String, ProcessorFormatIface>();
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorExecutor.class);

    public ProcessorExecutor(List<ProcessorFormatIface> processors) {
        for (ProcessorFormatIface processor : processors) {
            this.addProcessorFormatSupport(processor);
        }
    }

    public void addProcessorFormatSupport(ProcessorFormatIface processorFormat) {
        this.processors.put(processorFormat.getName(), processorFormat);
    }

    public String execute(String inData, List<SelectorIface> selectors) throws ProcessorException {
        String incompleteProcessedInData = inData;
        for (SelectorIface selector : selectors) {
            try {
                incompleteProcessedInData = this.processors.get(selector.getName()).process(incompleteProcessedInData, selector);
            }
            catch (Exception e) {
                throw new ProcessorException("Failed to execute processor " + selector.getName(), e);
            }
        }
        return incompleteProcessedInData;
    }
}

