/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.proto.messages;

public abstract class AbstractMessage {
    public static final byte CONNECT = 1;
    public static final byte CONNACK = 2;
    public static final byte PUBLISH = 3;
    public static final byte PUBACK = 4;
    public static final byte PUBREC = 5;
    public static final byte PUBREL = 6;
    public static final byte PUBCOMP = 7;
    public static final byte SUBSCRIBE = 8;
    public static final byte SUBACK = 9;
    public static final byte UNSUBSCRIBE = 10;
    public static final byte UNSUBACK = 11;
    public static final byte PINGREQ = 12;
    public static final byte PINGRESP = 13;
    public static final byte DISCONNECT = 14;
    protected boolean m_dupFlag;
    protected QOSType m_qos;
    protected boolean m_retainFlag;
    protected int m_remainingLength;
    protected byte m_messageType;

    public byte getMessageType() {
        return this.m_messageType;
    }

    public void setMessageType(byte messageType) {
        this.m_messageType = messageType;
    }

    public boolean isDupFlag() {
        return this.m_dupFlag;
    }

    public void setDupFlag(boolean dupFlag) {
        this.m_dupFlag = dupFlag;
    }

    public QOSType getQos() {
        return this.m_qos;
    }

    public void setQos(QOSType qos) {
        this.m_qos = qos;
    }

    public boolean isRetainFlag() {
        return this.m_retainFlag;
    }

    public void setRetainFlag(boolean retainFlag) {
        this.m_retainFlag = retainFlag;
    }

    public int getRemainingLength() {
        return this.m_remainingLength;
    }

    public void setRemainingLength(int remainingLength) {
        this.m_remainingLength = remainingLength;
    }

    public static enum QOSType {
        MOST_ONE,
        LEAST_ONE,
        EXACTLY_ONCE,
        RESERVED,
        FAILURE;


        public static QOSType valueOf(byte qos) {
            switch (qos) {
                case 0: {
                    return MOST_ONE;
                }
                case 1: {
                    return LEAST_ONE;
                }
                case 2: {
                    return EXACTLY_ONCE;
                }
                case -128: {
                    return FAILURE;
                }
            }
            throw new IllegalArgumentException("Invalid QOS Type. Expected either 0, 1, 2, or 0x80. Given: " + qos);
        }

        public byte byteValue() {
            switch (this) {
                case MOST_ONE: {
                    return 0;
                }
                case LEAST_ONE: {
                    return 1;
                }
                case EXACTLY_ONCE: {
                    return 2;
                }
                case FAILURE: {
                    return -128;
                }
            }
            throw new IllegalArgumentException("Cannot give byteValue of QOSType: " + this.name());
        }

        public static String formatQoS(QOSType qos) {
            return String.format("%d - %s", qos.byteValue(), qos.name());
        }
    }
}

