/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import org.eclipse.sensinact.gateway.core.security.AccessToken;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.LoginResponse;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundEndpoints;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.RegisteringResponse;
import org.eclipse.sensinact.gateway.util.CryptoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessingEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(AccessingEndpoint.class);
    private NorthboundMediator mediator;

    public AccessingEndpoint(NorthboundMediator mediator) {
        this.mediator = mediator;
    }

    public LoginResponse createNorthboundEndpoint(Credentials credentials) throws InvalidCredentialException {
        LoginResponse response = new LoginResponse(LoginResponse.TokenMode.TOKEN_CREATION);
        if (credentials == null) {
            throw new InvalidCredentialException("Null credentials");
        }
        NorthboundEndpoints endpoints = this.mediator.getNorthboundEndpoints();
        NorthboundEndpoint endpoint = endpoints.add(new NorthboundEndpoint(this.mediator, (Authentication<?>)credentials));
        long lifetime = endpoints.getLifetime();
        long timeout = endpoints.getTimeout(endpoint.getSessionToken());
        response.setTimeout(timeout);
        response.setGenerated(timeout - lifetime);
        response.setToken(endpoint.getSessionToken());
        return response;
    }

    public LoginResponse createNorthboundEndpoint(AccessToken accessToken) throws InvalidCredentialException {
        LoginResponse response = new LoginResponse(LoginResponse.TokenMode.TOKEN_CREATION);
        if (accessToken == null) {
            throw new InvalidCredentialException("Null access token");
        }
        NorthboundEndpoints endpoints = this.mediator.getNorthboundEndpoints();
        NorthboundEndpoint endpoint = endpoints.add(new NorthboundEndpoint(this.mediator, (Authentication<?>)accessToken));
        long lifetime = endpoints.getLifetime();
        long timeout = endpoints.getTimeout(endpoint.getSessionToken());
        response.setTimeout(timeout);
        response.setGenerated(timeout - lifetime);
        response.setToken(endpoint.getSessionToken());
        return response;
    }

    public LoginResponse reactivateEndpoint(SessionToken token) {
        String authenticationMaterial;
        LoginResponse response = new LoginResponse(LoginResponse.TokenMode.TOKEN_RENEW);
        String string = authenticationMaterial = token == null ? null : token.getAuthenticationMaterial();
        if (token != null) {
            NorthboundEndpoints endpoints = this.mediator.getNorthboundEndpoints();
            try {
                NorthboundEndpoint endpoint = endpoints.getEndpoint(token);
                if (endpoint == null) {
                    throw new NullPointerException("Null endpoint");
                }
                long lifetime = endpoints.getLifetime();
                long timeout = endpoints.getTimeout(authenticationMaterial);
                response.setTimeout(timeout);
                response.setGenerated(timeout - lifetime);
                response.setToken(authenticationMaterial);
            }
            catch (NullPointerException | InvalidCredentialException e) {
                LOG.error(e.getMessage(), e);
                response.setErrors((Exception)e);
            }
        } else {
            response.setErrors(new NullPointerException("Null token"));
        }
        return response;
    }

    public RegisteringResponse registeringEndpoint(String login, String password, String account, String accountType) {
        RegisteringResponse response = new RegisteringResponse(RegisteringResponse.RegisteringRequest.USER_CREATION);
        if (login != null && password != null && account != null && accountType != null) {
            try {
                NorthboundEndpoint endpoint = this.mediator.getNorthboundEndpoints().getEndpoint();
                String encryptedPassword = CryptoUtils.cryptWithMD5((String)password);
                endpoint.registerUser(login, encryptedPassword, account, accountType);
                response.setMessage("Registering in progress");
            }
            catch (Exception e) {
                response.setMessage("Error when registering");
                response.setErrors(e);
                LOG.error(e.getMessage(), (Throwable)e);
            }
        } else {
            response.setMessage("Error when registering");
            response.setErrors(new NullPointerException("login, password, account, and account type are required"));
        }
        return response;
    }

    public RegisteringResponse passwordRenewingEndpoint(String account) {
        RegisteringResponse response = new RegisteringResponse(RegisteringResponse.RegisteringRequest.PASSWORD_RENEW);
        if (account != null) {
            try {
                NorthboundEndpoint endpoint = this.mediator.getNorthboundEndpoints().getEndpoint();
                endpoint.renewUserPassword(account);
                response.setMessage("Password renewing in progress");
            }
            catch (Exception e) {
                response.setMessage("Error when renewing the password");
                response.setErrors(e);
                LOG.error(e.getMessage(), (Throwable)e);
            }
        } else {
            response.setErrors(new NullPointerException("account required"));
        }
        return response;
    }
}

