/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.util.CastUtils;

public final class NorthboundEndpoints {
    public static final String NORTHBOUND_ENDPOINT_LIFETIME = "org.eclipse.sensinact.ntbnd.endpoint.lifetime";
    private static final long DEFAULT_LIFETIME = 300000L;
    private final Object lock = new Object();
    private Map<Term, NorthboundEndpoint> endpoints;
    private NorthboundMediator mediator;
    private Schedule schedule;
    private final long lifetime;

    public NorthboundEndpoints(NorthboundMediator mediator) {
        Object lifetimeProp = mediator.getProperty(NORTHBOUND_ENDPOINT_LIFETIME);
        Long l = null;
        this.lifetime = lifetimeProp == null || (l = (Long)CastUtils.castPrimitive(Long.class, (Object)lifetimeProp)) == null || l < 1000L ? 300000L : l;
        this.endpoints = Collections.synchronizedMap(new WeakHashMap());
        this.schedule = new Schedule();
        this.mediator = mediator;
        new Thread(this.schedule).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NorthboundEndpoint getEndpoint() throws InvalidCredentialException {
        NorthboundEndpoint endpoint = new NorthboundEndpoint(this.mediator, null);
        Term term = new Term(endpoint.getSessionToken());
        term.reactivate();
        Object object = this.lock;
        synchronized (object) {
            this.schedule.add(term);
        }
        this.endpoints.put(term, endpoint);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NorthboundEndpoint getEndpoint(SessionToken token) throws InvalidCredentialException {
        if (token == null) {
            return null;
        }
        String sessionIdentifier = token.getAuthenticationMaterial();
        Term t = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.schedule.update(sessionIdentifier)) {
                t = this.schedule.getTerm(sessionIdentifier);
            }
        }
        if (t != null) {
            return this.endpoints.get(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NorthboundEndpoint add(NorthboundEndpoint northboundEndpoint) {
        String sessionToken;
        String string = sessionToken = northboundEndpoint == null ? null : northboundEndpoint.getSessionToken();
        if (sessionToken == null) {
            return null;
        }
        Term t = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.schedule.update(northboundEndpoint.getSessionToken())) {
                t = this.schedule.getTerm(northboundEndpoint.getSessionToken());
            }
        }
        if (t != null) {
            return this.endpoints.get(t);
        }
        t = new Term(sessionToken);
        t.reactivate();
        object = this.lock;
        synchronized (object) {
            this.schedule.add(t);
        }
        this.endpoints.put(t, northboundEndpoint);
        return northboundEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout(String sessionToken) {
        long timeout = -1L;
        Term t = null;
        Object object = this.lock;
        synchronized (object) {
            t = this.schedule.getTerm(sessionToken);
        }
        if (t != null) {
            timeout = t.timeout.get();
        }
        return timeout;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void close() {
        this.schedule.stop();
    }

    private final class Schedule
    implements Runnable {
        private volatile boolean running = false;
        private Map<String, Term> map = new HashMap<String, Term>();
        private Term head = null;
        private Term queue = null;

        Schedule() {
        }

        void stop() {
            this.running = false;
        }

        Term getTerm(String sessionIdentifier) {
            Term term = null;
            term = this.map.get(sessionIdentifier);
            return term;
        }

        boolean update(String sessionIdentifier) {
            Term term = this.remove(sessionIdentifier);
            if (term != null) {
                term.reactivate();
                this.add(term);
                return true;
            }
            return false;
        }

        Term remove(String sessionIdentifier) {
            Term term = this.map.remove(sessionIdentifier);
            if (term == null) {
                return term;
            }
            if (term == this.head) {
                this.head = term.next;
            }
            if (term == this.queue) {
                this.queue = term.previous;
            }
            if (term.previous != null) {
                term.previous.next = term.next;
            }
            if (term.next != null) {
                term.next.previous = term.previous;
            }
            term.next = null;
            term.previous = null;
            return term;
        }

        Term add(Term term) {
            Term old = null;
            if (term == null || term.identifier == null) {
                return old;
            }
            term.previous = this.queue;
            if (this.queue != null) {
                this.queue.next = term;
            } else {
                this.head = term;
            }
            this.queue = term;
            old = this.map.put(term.identifier, term);
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                Object object = NorthboundEndpoints.this.lock;
                synchronized (object) {
                    while (this.head != null && this.head.expired()) {
                        this.map.remove(this.head.identifier);
                        this.head = this.head.next;
                        if (this.head == null) continue;
                        this.head.previous = null;
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    this.running = false;
                }
            }
            this.map.clear();
            Term n = this.head;
            Term t = null;
            while (n != null) {
                t = n.next;
                n.previous = null;
                n.next = null;
                n = t;
                t = null;
            }
            this.head = null;
            this.queue = null;
        }
    }

    private final class Term {
        Term previous;
        Term next;
        final String identifier;
        final AtomicLong timeout;

        Term(String identifier) {
            this.identifier = identifier;
            this.timeout = new AtomicLong(0L);
        }

        final void reactivate() {
            this.timeout.set(System.currentTimeMillis() + NorthboundEndpoints.this.lifetime);
        }

        final boolean expired() {
            return System.currentTimeMillis() > this.timeout.get();
        }
    }
}

