/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.android;

import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.android.AndroidWebSocketPool;
import org.eclipse.sensinact.gateway.sthbnd.http.android.DevGenPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.android.IndexFilter;
import org.eclipse.sensinact.gateway.sthbnd.http.android.ResourceFilter;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequireHttpWhiteboard
@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends AbstractActivator<Mediator> {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static ClassLoader loader = null;
    public LocalProtocolStackEndpoint<DevGenPacket> connector;

    private static void findJettyClassLoader(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            if (!"org.apache.felix.http.jetty".equals(bundle.getSymbolicName())) continue;
            try {
                BundleWiring wire = (BundleWiring)bundle.adapt(BundleWiring.class);
                loader = wire.getClassLoader();
            }
            catch (Exception e) {
                e.printStackTrace();
                loader = WebSocketServlet.class.getClassLoader();
            }
            break;
        }
    }

    public void doStart() {
        Activator.findJettyClassLoader(this.mediator.getContext());
        ExtModelConfiguration configuration = ExtModelConfigurationBuilder.instance((Mediator)this.mediator, DevGenPacket.class).withServiceBuildPolicy((byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy())).withResourceBuildPolicy((byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy())).withStartAtInitializationTime(true).build(new Object[]{"resources.xml", Collections.emptyMap()});
        this.connector = new LocalProtocolStackEndpoint(this.mediator);
        try {
            this.connector.connect(configuration);
        }
        catch (InvalidProtocolStackException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.mediator.register((Dictionary)new Hashtable<String, Object>(){
            {
                this.put("osgi.http.whiteboard.servlet.pattern", "/androidws");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.eclipse.sensinact)");
            }
        }, (Object)new WebSocketServlet(){
            private static final long serialVersionUID = 1L;
            private AndroidWebSocketPool pool;
            private final AtomicBoolean firstCall;
            private final CountDownLatch initBarrier;
            {
                this.pool = new AndroidWebSocketPool(Activator.this.mediator, Activator.this.connector);
                this.firstCall = new AtomicBoolean(true);
                this.initBarrier = new CountDownLatch(1);
            }

            public void init() throws ServletException {
                LOG.info("The Echo servlet has been initialized, but we delay initialization until the first request so that a Jetty Context is available");
            }

            public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
                if (this.firstCall.compareAndSet(true, false)) {
                    try {
                        this.delayedInit();
                    }
                    finally {
                        this.initBarrier.countDown();
                    }
                }
                try {
                    this.initBarrier.await();
                }
                catch (InterruptedException e) {
                    throw new ServletException("Timed out waiting for initialisation", (Throwable)e);
                }
                super.service(arg0, arg1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void delayedInit() throws ServletException {
                Thread currentThread = Thread.currentThread();
                ClassLoader tccl = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(loader);
                try {
                    super.init();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    currentThread.setContextClassLoader(tccl);
                }
            }

            public void configure(WebSocketServletFactory factory) {
                factory.getPolicy().setIdleTimeout(3600000L);
                factory.setCreator((WebSocketCreator)this.pool);
            }
        }, new Class[]{Servlet.class, WebSocketServlet.class});
        LOG.info(String.format("%s servlet registered", "/androidws"));
        this.mediator.register((Object)new IndexFilter("/android"), Filter.class, (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.ranking", 3);
                this.put("osgi.http.whiteboard.filter.pattern", "/android");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.eclipse.sensinact)");
            }
        });
        LOG.info(String.format("%s filter registered", "/android"));
        this.mediator.register((Object)new ResourceFilter(this.mediator), Filter.class, (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.ranking", 2);
                this.put("osgi.http.whiteboard.filter.pattern", "/android/*");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.eclipse.sensinact)");
            }
        });
        LOG.info(String.format("%s filter registered", "/android/*"));
    }

    public void doStop() {
        LOG.info("Stopping bundle");
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }
}

