/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.persistence;

import io.moquette.spi.IMatchingCondition;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.MessageGUID;
import io.moquette.spi.persistence.MapDBSessionsStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapDBMessagesStore
implements IMessagesStore {
    private static final Logger LOG = LoggerFactory.getLogger(MapDBMessagesStore.class);
    private DB m_db;
    private ConcurrentMap<String, MessageGUID> m_retainedStore;
    private ConcurrentMap<MessageGUID, IMessagesStore.StoredMessage> m_persistentMessageStore;

    MapDBMessagesStore(DB db) {
        this.m_db = db;
    }

    @Override
    public void initStore() {
        this.m_retainedStore = this.m_db.getHashMap("retained");
        this.m_persistentMessageStore = this.m_db.getHashMap("persistedMessages");
    }

    @Override
    public void storeRetained(String topic, MessageGUID guid) {
        this.m_retainedStore.put(topic, guid);
    }

    @Override
    public Collection<IMessagesStore.StoredMessage> searchMatching(IMatchingCondition condition) {
        LOG.debug("searchMatching scanning all retained messages, presents are {}", (Object)this.m_retainedStore.size());
        ArrayList<IMessagesStore.StoredMessage> results = new ArrayList<IMessagesStore.StoredMessage>();
        for (Map.Entry entry : this.m_retainedStore.entrySet()) {
            MessageGUID guid = (MessageGUID)entry.getValue();
            IMessagesStore.StoredMessage storedMsg = (IMessagesStore.StoredMessage)this.m_persistentMessageStore.get(guid);
            if (!condition.match((String)entry.getKey())) continue;
            results.add(storedMsg);
        }
        return results;
    }

    @Override
    public MessageGUID storePublishForFuture(IMessagesStore.StoredMessage storedMessage) {
        LOG.debug("storePublishForFuture store evt {}", (Object)storedMessage);
        if (storedMessage.getClientID() == null) {
            LOG.error("persisting a message without a clientID, bad programming error msg: {}", (Object)storedMessage);
            throw new IllegalArgumentException("persisting a message without a clientID, bad programming error");
        }
        MessageGUID guid = new MessageGUID(UUID.randomUUID().toString());
        storedMessage.setGuid(guid);
        LOG.debug("storePublishForFuture guid <{}>", (Object)guid);
        this.m_persistentMessageStore.put(guid, storedMessage);
        HTreeMap<Integer, MessageGUID> messageIdToGuid = this.m_db.getHashMap(MapDBSessionsStore.messageId2GuidsMapName(storedMessage.getClientID()));
        messageIdToGuid.put(storedMessage.getMessageID(), guid);
        return guid;
    }

    @Override
    public void dropMessagesInSession(String clientID) {
        HTreeMap messageIdToGuid = this.m_db.getHashMap(MapDBSessionsStore.messageId2GuidsMapName(clientID));
        for (MessageGUID guid : messageIdToGuid.values()) {
            this.removeStoredMessage(guid);
        }
        messageIdToGuid.clear();
    }

    void removeStoredMessage(MessageGUID guid) {
        IMessagesStore.StoredMessage storedMessage = (IMessagesStore.StoredMessage)this.m_persistentMessageStore.get(guid);
        if (!storedMessage.isRetained()) {
            LOG.debug("Cleaning not retained message guid {}", (Object)guid);
            this.m_persistentMessageStore.remove(guid);
        }
    }

    @Override
    public IMessagesStore.StoredMessage getMessageByGuid(MessageGUID guid) {
        return (IMessagesStore.StoredMessage)this.m_persistentMessageStore.get(guid);
    }

    @Override
    public void cleanRetained(String topic) {
        this.m_retainedStore.remove(topic);
    }
}

