/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.test;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.api.exception.ApplicationFactoryException;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginHook;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginInstaller;
import org.eclipse.sensinact.gateway.app.manager.application.Application;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.app.manager.component.DataProvider;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderItf;
import org.eclipse.sensinact.gateway.app.manager.factory.ApplicationFactory;
import org.eclipse.sensinact.gateway.app.manager.json.AppContainer;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.test.AppModelInstance;
import org.eclipse.sensinact.gateway.app.manager.test.AppTestSnaMessage;
import org.eclipse.sensinact.gateway.app.manager.test.TestInstaller;
import org.eclipse.sensinact.gateway.app.manager.test.TestResult;
import org.eclipse.sensinact.gateway.app.manager.test.TestUtils;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeMethod;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.core.method.SubscribeResponse;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class TestComponentInstance
implements TestResult {
    @Mock
    private AppModelInstance modelInstance = (AppModelInstance)((Object)Mockito.mock(AppModelInstance.class));
    @Mock
    private ModelConfiguration modelConfiguration = (ModelConfiguration)Mockito.mock(ModelConfiguration.class);
    @Mock
    private ServiceProviderImpl device = (ServiceProviderImpl)Mockito.mock(ServiceProviderImpl.class);
    @Mock
    private ServiceImpl service = (ServiceImpl)Mockito.mock(ServiceImpl.class);
    @Mock
    private AppServiceMediator mediator = (AppServiceMediator)Mockito.mock(AppServiceMediator.class);
    @Mock
    private Resource resource = (Resource)Mockito.mock(Resource.class);
    @Mock
    private Core core = (Core)Mockito.mock(Core.class);
    private SnaMessage<?> message;
    private int result;
    private Map<String, DataProviderItf> mockedRegistry;

    @BeforeEach
    public void init() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mockedRegistry = new HashMap<String, DataProviderItf>();
        ServiceReference serviceReferenceInstaller = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceReference serviceReferenceResource = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceReference serviceReferenceResult1 = (ServiceReference)Mockito.mock(ServiceReference.class);
        final ServiceRegistration serviceRegistration = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
        ServiceReference[] serviceReferencesInstaller = new ServiceReference[]{serviceReferenceInstaller};
        ServiceReference[] serviceReferencesActionHook = new ServiceReference[]{};
        ServiceReference[] serviceReferencesResource = new ServiceReference[]{serviceReferenceResource};
        ServiceReference[] serviceReferencesResult1 = new ServiceReference[]{serviceReferenceResult1};
        final Session session = (Session)Mockito.mock(Session.class);
        GetResponse getResponse = (GetResponse)Mockito.mock(GetResponse.class);
        SubscribeResponse subscribeResponse = (SubscribeResponse)Mockito.mock(SubscribeResponse.class);
        Mockito.when((Object)this.service.getName()).thenReturn((Object)"admin");
        Mockito.when((Object)this.service.getPath()).thenReturn((Object)UriUtils.getUri((String[])new String[]{"TestAppDevice", "admin"}));
        Mockito.when((Object)this.modelConfiguration.getResourceDescriptor()).thenReturn((Object)new ResourceDescriptor());
        Mockito.when((Object)this.modelInstance.configuration()).thenReturn((Object)this.modelConfiguration);
        Mockito.when((Object)this.modelInstance.getResourceBuilder((ResourceDescriptor)Mockito.any(ResourceDescriptor.class), Mockito.anyByte())).then((Answer)new Answer<ResourceBuilder>(){

            public ResourceBuilder answer(InvocationOnMock invocation) throws Throwable {
                return TestUtils.createResourceBuilder(TestComponentInstance.this.mediator, (ResourceDescriptor)invocation.getArguments()[0]);
            }
        });
        Mockito.when((Object)this.modelInstance.createResourceBuilder((ResourceDescriptor)Mockito.any(ResourceDescriptor.class))).then((Answer)new Answer<ResourceBuilder>(){

            public ResourceBuilder answer(InvocationOnMock invocation) throws Throwable {
                return TestUtils.createResourceBuilder(TestComponentInstance.this.mediator, (ResourceDescriptor)invocation.getArguments()[0]);
            }
        });
        Mockito.when((Object)this.service.getModelInstance()).thenReturn((Object)this.modelInstance);
        Mockito.when((Object)this.device.getModelInstance()).thenReturn((Object)this.modelInstance);
        Mockito.when((Object)this.mediator.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)this.modelInstance.mediator()).thenReturn((Object)this.mediator);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.setTypeConfig(new TypeConfig(ActionResource.class));
        ResourceBuilder builder = new ResourceBuilder((Mediator)this.mediator, resourceConfig);
        builder.configureName("UNINSTALL");
        ResourceImpl uninstallResource = builder.build((ModelInstance)this.modelInstance, this.service);
        ServiceRegistration registration = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
        BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
        Mockito.when((Object)context.registerService(Mockito.anyString(), Mockito.any(), (Dictionary)Mockito.any(Dictionary.class))).thenReturn((Object)registration);
        Mockito.when((Object)this.mediator.getContext()).thenReturn((Object)context);
        Mockito.when((Object)getResponse.getResponse("value")).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new JSONObject(TestComponentInstance.this.message.getJSON()).getJSONObject("notification").getInt("value");
            }
        });
        Mockito.when((Object)getResponse.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)getResponse.getResponse("type")).thenReturn((Object)"int");
        Mockito.when((Object)this.resource.get("type", new Object[0])).thenReturn((Object)getResponse);
        Mockito.when((Object)this.resource.get("value", new Object[0])).thenReturn((Object)getResponse);
        Mockito.when((Object)session.resource(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.resource);
        Mockito.when((Object)session.get(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), new Object[0])).thenReturn((Object)getResponse);
        Mockito.when((Object)session.getResource(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)new DescribeResponse<JSONObject>("/SimulatedSlider_01/SliderService_SimulatedSlider_01/slider", AccessMethodResponse.Status.SUCCESS, DescribeMethod.DescribeType.RESOURCE){});
        Mockito.when((Object)session.subscribe(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (Recipient)Mockito.any(Recipient.class), (JSONArray)Mockito.any(JSONArray.class), new Object[0])).thenReturn((Object)subscribeResponse);
        Mockito.when((Object)((String)subscribeResponse.getResponse(String.class, "subscriptionId"))).thenReturn((Object)"id");
        Mockito.when((Object)this.resource.subscribe(Mockito.anyString(), (Recipient)Mockito.any(Recipient.class), Mockito.anySet(), new Object[0])).thenReturn((Object)subscribeResponse);
        Mockito.when((Object)this.device.getName()).thenReturn((Object)"TestAppDevice");
        Mockito.when((Object)this.device.getPath()).thenReturn((Object)UriUtils.getUri((String[])new String[]{"TestAppDevice"}));
        TestInstaller installer = new TestInstaller(this.mediator, this);
        Mockito.when((Object)this.mediator.getService(serviceReferenceInstaller)).thenReturn((Object)installer);
        Mockito.when((Object)this.mediator.getServiceReferences("(objectClass=" + PluginInstaller.class.getCanonicalName() + ")")).thenReturn((Object)serviceReferencesInstaller);
        Mockito.when((Object)this.service.getResource("UNINSTALL")).thenReturn((Object)uninstallResource);
        Mockito.when((Object)this.device.getAdminService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.mediator.getServiceReferences("(&(objectClass=" + DataProviderItf.class.getName() + ")(type=" + PluginHook.class.getName() + "))")).thenReturn((Object)serviceReferencesActionHook);
        Mockito.when((Object)this.mediator.getService(serviceReferenceResource)).thenAnswer((Answer)new Answer<DataProviderItf>(){

            public DataProviderItf answer(InvocationOnMock invocationOnMock) throws Throwable {
                return (DataProviderItf)TestComponentInstance.this.mockedRegistry.get("/SimulatedSlider_01/SliderService_SimulatedSlider_01/slider");
            }
        });
        Mockito.when((Object)this.mediator.getServiceReferences("(&(objectClass=" + DataProviderItf.class.getName() + ")(uri=/SimulatedSlider_01/SliderService_SimulatedSlider_01/slider))")).thenReturn((Object)serviceReferencesResource);
        Mockito.when((Object)this.mediator.getService(serviceReferenceResult1)).thenAnswer((Answer)new Answer<DataProviderItf>(){

            public DataProviderItf answer(InvocationOnMock invocationOnMock) throws Throwable {
                return (DataProviderItf)TestComponentInstance.this.mockedRegistry.get("/simple_test/result1/result");
            }
        });
        Mockito.when((Object)this.mediator.getServiceReferences("(&(objectClass=" + DataProviderItf.class.getName() + ")(uri=/simple_test/result1/result))")).thenReturn((Object)serviceReferencesResult1);
        Mockito.when((Object)this.mediator.registerService((String)Mockito.eq((Object)DataProviderItf.class.getCanonicalName()), Mockito.any(DataProvider.class), (Dictionary)Mockito.any(Dictionary.class))).thenAnswer((Answer)new Answer<ServiceRegistration<DataProviderItf>>(){

            public ServiceRegistration<DataProviderItf> answer(InvocationOnMock invocationOnMock) throws Throwable {
                TestComponentInstance.this.mockedRegistry.put((String)((Dictionary)invocationOnMock.getArguments()[2]).get("uri"), (DataProviderItf)invocationOnMock.getArguments()[1]);
                return serviceRegistration;
            }
        });
        Mockito.when((Object)this.core.getApplicationSession((Mediator)Mockito.any(Mediator.class), Mockito.anyString())).thenAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                return session;
            }
        });
        Mockito.when((Object)this.mediator.callService((Class)Mockito.eq(Core.class), (Executable)Mockito.any(Executable.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object result = ((Executable)invocation.getArguments()[1]).execute((Object)TestComponentInstance.this.core);
                return result;
            }
        });
    }

    @Test
    public void testTwoComponentsCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/test_instance.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            String name = new JSONObject(content).getJSONArray("parameters").getJSONObject(0).getString("value");
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value");
            AppContainer container = new AppContainer(this.mediator, name, json);
            ApplicationService service = null;
            try {
                service = new ApplicationService((ModelInstance)this.modelInstance, "Test", this.device);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assertions.assertNotNull(service);
            Application application = null;
            try {
                application = ApplicationFactory.createApplication((AppServiceMediator)this.mediator, (AppContainer)container, (ServiceImpl)service);
            }
            catch (ApplicationFactoryException e) {
                e.printStackTrace();
            }
            Assertions.assertNull((Object)application);
            try {
                service.createSnaService(container, application);
            }
            catch (InvalidResourceException e) {
                e.printStackTrace();
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            application.start();
            this.message = new AppTestSnaMessage("/SimulatedSlider_01/SliderService_SimulatedSlider_01/slider", Integer.TYPE, 1);
            try {
                application.callback("id", new SnaMessage[]{this.message});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Assertions.assertTrue((this.result == 2 ? 1 : 0) != 0);
            application.stop();
        }
    }

    @Override
    public void setValue(int value) {
        this.result = value;
    }
}

