/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.app.api.persistence.ApplicationPersistenceService;
import org.eclipse.sensinact.gateway.app.api.persistence.dao.Application;
import org.eclipse.sensinact.gateway.app.api.persistence.exception.ApplicationPersistenceException;
import org.eclipse.sensinact.gateway.app.api.persistence.listener.ApplicationAvailabilityListener;
import org.eclipse.sensinact.gateway.app.manager.application.persistence.FileToApplicationParser;
import org.eclipse.sensinact.gateway.app.manager.application.persistence.exception.ApplicationParseException;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ApplicationPersistenceService.class}, scope=ServiceScope.SINGLETON)
@ServiceRanking(value=100)
@Designate(ocd=Config.class)
public class FileSystemApplicationPersistenceService
implements ApplicationPersistenceService {
    private final Logger LOG = LoggerFactory.getLogger(FileSystemApplicationPersistenceService.class);
    private File directory;
    private long readingDelay;
    private String fileExtention;
    private final List<String> files = new ArrayList<String>();
    private final Map<String, Application> filesPath = new HashMap<String, Application>();
    private final Set<ApplicationAvailabilityListener> listener = new HashSet<ApplicationAvailabilityListener>();
    private Boolean active = Boolean.TRUE;
    private Thread persistenceThread;
    private static final Object lock = new Object();

    @Activate
    public void activate(Config config) {
        this.directory = new File(config.directory());
        this.readingDelay = config.readingDelay();
        this.fileExtention = config.fileExtention();
        this.persistenceThread = new Thread(() -> {
            this.notifyServiceAvailable();
            while (this.active.booleanValue()) {
                try {
                    Object object = lock;
                    synchronized (object) {
                        ArrayList<String> filesToBeProcessed = new ArrayList<String>();
                        for (File applicationFile : this.directory.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith("." + FileSystemApplicationPersistenceService.this.fileExtention);
                            }
                        })) {
                            filesToBeProcessed.add(applicationFile.getAbsolutePath());
                        }
                        ArrayList<String> filesRemoved = new ArrayList<String>(this.files);
                        filesRemoved.removeAll(filesToBeProcessed);
                        for (String fileRemoved : filesRemoved) {
                            this.notifyRemoval(fileRemoved);
                        }
                        for (String toprocess : filesToBeProcessed) {
                            try {
                                Boolean fileManaged = this.filesPath.containsKey(toprocess);
                                if (!fileManaged.booleanValue()) {
                                    this.LOG.info("Application file {} will be loaded.", (Object)toprocess);
                                    this.notifyInclusion(toprocess);
                                    continue;
                                }
                                Application applicationManaged = this.filesPath.get(toprocess);
                                Application applicationInFs = FileToApplicationParser.parse(toprocess);
                                if (applicationManaged.getDiggest().equals(applicationInFs.getDiggest())) continue;
                                this.LOG.info("Application file {} was already loaded but its content changed, dispatching update.", (Object)toprocess);
                                this.notifyModification(toprocess);
                                this.LOG.info("Application file {}, update procedure finished.", (Object)toprocess);
                            }
                            catch (Exception e) {
                                this.LOG.warn("Failed to process application description file {}", (Object)toprocess, (Object)e);
                            }
                        }
                    }
                    Thread.sleep(this.readingDelay);
                }
                catch (Exception e) {
                    this.LOG.error("Application persistency system failed", (Throwable)e);
                }
            }
            this.notifyServiceUnavailable();
            this.LOG.error("Application persistency system is exiting");
        });
        this.persistenceThread.setDaemon(true);
        this.persistenceThread.setPriority(1);
        this.persistenceThread.start();
    }

    @Deactivate
    public void deactivate() {
        if (this.persistenceThread != null) {
            this.persistenceThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(Application application) throws ApplicationPersistenceException {
        String filename = this.directory + File.separator + application.getName() + "." + this.fileExtention;
        Object object = lock;
        synchronized (object) {
            File file = new File(filename);
            try {
                file.createNewFile();
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(application.getContent().toString().getBytes());
                fos.close();
            }
            catch (IOException e) {
                this.LOG.error("Failed to create application file {} into the disk.", (Object)filename);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String applicationName) throws ApplicationPersistenceException {
        String filename = this.directory + File.separator + applicationName + "." + this.fileExtention;
        Object object = lock;
        synchronized (object) {
            File file = new File(filename);
            try {
                file.delete();
            }
            catch (Exception e) {
                this.LOG.error("Failed to remove application file {} from the disk.", (Object)filename);
            }
        }
    }

    @Override
    public JSONObject fetch(String applicationName) throws ApplicationPersistenceException {
        throw new UnsupportedOperationException("Persistence to the disk is not available");
    }

    @Override
    public Collection<Application> list() {
        return Collections.unmodifiableCollection(this.filesPath.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServiceAvailabilityListener(ApplicationAvailabilityListener listenerClient) {
        Set<ApplicationAvailabilityListener> set = this.listener;
        synchronized (set) {
            this.listener.add(listenerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterServiceAvailabilityListener(ApplicationAvailabilityListener listenerClient) {
        Set<ApplicationAvailabilityListener> set = this.listener;
        synchronized (set) {
            this.listener.remove(listenerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInclusion(String filepath) {
        try {
            Application application = FileToApplicationParser.parse(filepath);
            this.LOG.info("Notifying application '{}' deployment ", (Object)filepath);
            for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listener)) {
                try {
                    ApplicationAvailabilityListener applicationAvailabilityListener = list;
                    synchronized (applicationAvailabilityListener) {
                        list.applicationFound(application.getName(), application.getContent().toString());
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Failed to add application {} into the platform, is ApplicationManager running?", (Object)application.getName(), (Object)e);
                }
            }
            this.manageFile(filepath);
        }
        catch (ApplicationParseException e) {
            this.LOG.error("Failed to read application file", (Throwable)e);
        }
    }

    private void unmanageFile(String filepath) {
        this.files.remove(filepath);
        this.filesPath.remove(filepath);
    }

    private void manageFile(String filepath) {
        try {
            Application application = FileToApplicationParser.parse(filepath);
            this.files.add(filepath);
            this.filesPath.put(filepath, application);
        }
        catch (ApplicationParseException e) {
            this.files.remove(filepath);
            this.filesPath.remove(filepath);
            this.LOG.error("Error processing file.", (Throwable)e);
        }
    }

    private void notifyModification(String filepath) {
        this.LOG.info("Notifying application '{}' changed", (Object)filepath);
        try {
            Application application = FileToApplicationParser.parse(filepath);
            if (application != null) {
                for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listener)) {
                    try {
                        list.applicationChanged(application.getName(), application.getContent().toString());
                    }
                    catch (Exception e) {
                        this.LOG.error("Failed to remove application from the platform", (Throwable)e);
                    }
                }
                this.manageFile(filepath);
            } else {
                this.LOG.warn("The application file '{}' was already notified by the system", (Object)filepath);
            }
        }
        catch (ApplicationParseException e) {
            e.printStackTrace();
        }
    }

    private void notifyRemoval(String filepath) {
        this.LOG.info("Notifying application '{}' removal", (Object)filepath);
        Application application = this.filesPath.get(filepath);
        this.unmanageFile(filepath);
        if (application != null) {
            for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listener)) {
                try {
                    list.applicationRemoved(application.getName());
                }
                catch (Exception e) {
                    this.LOG.error("Failed to remove application from the platform", (Throwable)e);
                }
            }
        } else {
            this.LOG.warn("The application file '{}' was already notified by the system", (Object)filepath);
        }
    }

    private void notifyServiceUnavailable() {
        this.LOG.debug("Persistence service is going offline");
        for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listener)) {
            try {
                list.serviceOffline();
            }
            catch (Exception e) {
                this.LOG.error("Persistence service is going offline", (Throwable)e);
            }
        }
    }

    private void notifyServiceAvailable() {
        this.LOG.debug("Persistence service is going online");
        for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listener)) {
            try {
                list.serviceOnline();
            }
            catch (Exception e) {
                this.LOG.error("Persistence service is going online", (Throwable)e);
            }
        }
    }

    @ObjectClassDefinition
    static @interface Config {
        public String directory() default "application";

        public long readingDelay() default 0L;

        public String fileExtention() default "json";
    }
}

