/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.component.data;

import org.eclipse.sensinact.gateway.app.api.function.DataItf;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.method.ActResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.core.method.SetResponse;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;

public class ResourceData
implements DataItf {
    private final Session session;
    private final String uri;
    private GetResponse last;

    public ResourceData(Session session, String uri) {
        this.session = session;
        this.uri = uri;
    }

    @Override
    public String getSourceUri() {
        return this.uri;
    }

    private DescribeResponse<JSONObject> describe() {
        String[] uriElements = UriUtils.getUriElements((String)this.getSourceUri());
        if (uriElements.length != 3) {
            return null;
        }
        DescribeResponse response = this.session.getResource(uriElements[0], uriElements[1], uriElements[2]);
        if (response == null || response.getStatusCode() != 200) {
            return null;
        }
        return response;
    }

    public GetResponse get() {
        String[] uriElements = UriUtils.getUriElements((String)this.getSourceUri());
        if (uriElements.length != 3) {
            return null;
        }
        GetResponse response = this.session.get(uriElements[0], uriElements[1], uriElements[2], "value", new Object[0]);
        if (response == null || response.getStatusCode() != 200) {
            this.last = null;
            return null;
        }
        this.last = response;
        return response;
    }

    public SetResponse set(Object value) {
        String[] uriElements = UriUtils.getUriElements((String)this.getSourceUri());
        if (uriElements.length != 3) {
            return null;
        }
        SetResponse response = this.session.set(uriElements[0], uriElements[1], uriElements[2], "value", value, new Object[0]);
        return response;
    }

    public ActResponse act(Object[] parameters) {
        String[] uriElements = UriUtils.getUriElements((String)this.getSourceUri());
        if (uriElements.length != 3) {
            return null;
        }
        ActResponse response = this.session.act(uriElements[0], uriElements[1], uriElements[2], parameters);
        return response;
    }

    @Override
    public Object getValue() {
        GetResponse response = this.get();
        if (response == null) {
            this.last = null;
            return null;
        }
        this.last = response;
        return response.getResponse("value");
    }

    @Override
    public Class<?> getType() {
        if (this.last == null) {
            this.get();
        }
        if (this.last == null) {
            return Object.class;
        }
        return CastUtils.jsonTypeToJavaType((String)((String)this.last.getResponse("type")));
    }

    public String getResourceType() {
        DescribeResponse<JSONObject> response = this.describe();
        if (response == null) {
            return null;
        }
        return (String)((JSONObject)response.getResponse()).get("type");
    }

    @Override
    public long getTimestamp() {
        if (this.last == null) {
            this.get();
        }
        if (this.last == null) {
            return 0L;
        }
        return (Long)this.last.getResponse(Long.class, "timestamp");
    }
}

