/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.json;

import org.eclipse.sensinact.gateway.app.manager.json.AppOperator;
import org.eclipse.sensinact.gateway.app.manager.json.AppParameter;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONObject;

public class AppCondition
implements JSONable {
    private final Mediator mediator;
    private final String operator;
    private final AppParameter parameter;
    private final boolean complement;

    public AppCondition(Mediator mediator, String operator, AppParameter parameter, boolean complement) {
        this.mediator = mediator;
        this.operator = operator;
        this.parameter = parameter;
        this.complement = complement;
    }

    public AppCondition(Mediator mediator, JSONObject condition) {
        this(mediator, condition.getString("operator"), new AppParameter(condition.get("value"), condition.getString("type")), condition.optBoolean("complement"));
    }

    public Constraint getConstraint() {
        try {
            return ConstraintFactory.Loader.load((ClassLoader)this.mediator.getClassLoader(), (String)AppOperator.getOperator(this.operator), (Class)CastUtils.jsonTypeToJavaType((String)this.parameter.getType()), (Object)this.parameter.getValue(), (boolean)this.complement);
        }
        catch (InvalidConstraintDefinitionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppCondition that = (AppCondition)o;
        if (this.complement != that.complement) {
            return false;
        }
        if (!this.operator.equals(that.operator)) {
            return false;
        }
        return this.parameter.equals(that.parameter);
    }

    public int hashCode() {
        int result = this.operator.hashCode();
        result = 31 * result + this.parameter.hashCode();
        result = 31 * result + (this.complement ? 1 : 0);
        return result;
    }

    public String getJSON() {
        return new JSONObject().put("operator", (Object)this.operator).put("value", this.parameter.getValue()).put("type", (Object)this.parameter.getType()).put("complement", this.complement).toString();
    }
}

