/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.json;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.app.manager.json.AppParameter;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppFunction
implements JSONable {
    private final String name;
    private final List<AppParameter> buildParameters;
    private final List<AppParameter> runParameters;

    public AppFunction(String name, List<AppParameter> buildParameters, List<AppParameter> runParameters) {
        this.name = name;
        this.buildParameters = buildParameters;
        this.runParameters = runParameters;
    }

    public AppFunction(JSONObject json) {
        int i;
        JSONArray parameterArray;
        this.name = json.getString("name");
        this.buildParameters = new ArrayList<AppParameter>();
        if (json.has("buildparameters")) {
            parameterArray = json.getJSONArray("buildparameters");
            for (i = 0; i < parameterArray.length(); ++i) {
                this.buildParameters.add(new AppParameter(parameterArray.getJSONObject(i)));
            }
        }
        this.runParameters = new ArrayList<AppParameter>();
        if (json.has("runparameters")) {
            parameterArray = json.getJSONArray("runparameters");
            for (i = 0; i < parameterArray.length(); ++i) {
                this.runParameters.add(new AppParameter(parameterArray.getJSONObject(i)));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public List<AppParameter> getBuildParameters() {
        return this.buildParameters;
    }

    public List<AppParameter> getRunParameters() {
        return this.runParameters;
    }

    public String getJSON() {
        JSONArray parametersArray;
        JSONObject function = new JSONObject();
        function.put("name", (Object)this.name);
        if (!this.buildParameters.isEmpty()) {
            parametersArray = new JSONArray();
            for (AppParameter parameter : this.buildParameters) {
                parametersArray.put((Object)parameter.getJSON());
            }
            function.put("buildparameters", (Object)parametersArray);
        }
        if (!this.runParameters.isEmpty()) {
            parametersArray = new JSONArray();
            for (AppParameter parameter : this.runParameters) {
                parametersArray.put((Object)parameter.getJSON());
            }
            function.put("runparameters", (Object)parametersArray);
        }
        return function.toString();
    }
}

