/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.json;

import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.json.JSONObject;

public class AppOptions
implements JSONable {
    private static final boolean DEFAULT_AUTORESTART_VALUE = false;
    private static final boolean DEFAULT_RESET_ON_STOP_VALUE = true;
    private final boolean autostart;
    private final boolean resetOnStop;

    private AppOptions(Builder builder) {
        this.autostart = builder.autorestart;
        this.resetOnStop = builder.resetOnStop;
    }

    public boolean getAutoStart() {
        return this.autostart;
    }

    public boolean getResetOnStop() {
        return this.resetOnStop;
    }

    public String getJSON() {
        return new JSONObject().put("autostart", this.autostart).put("resetonstop", this.resetOnStop).toString();
    }

    public static class Builder {
        private boolean autorestart = false;
        private boolean resetOnStop = true;

        Builder autorestart(boolean autorestart) {
            this.autorestart = autorestart;
            return this;
        }

        Builder resetOnStop(boolean resetOnStop) {
            this.resetOnStop = resetOnStop;
            return this;
        }

        public AppOptions build() {
            return new AppOptions(this);
        }
    }
}

