/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.local;

import java.util.Arrays;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.annotation.TaskCommand;
import org.eclipse.sensinact.gateway.util.CastUtils;

public abstract class AnnotationExecutor
implements Executable<Task, Object>,
Nameable {
    private final String target;
    private final Task.CommandType commandType;
    private final TaskCommand.SynchronizationPolicy synchronization;
    private final String profile;
    private final Class<?>[] parameterTypes;
    private final boolean allProfiles;
    private boolean isVarArg;

    AnnotationExecutor(String target, Task.CommandType commandType, TaskCommand.SynchronizationPolicy synchronization, boolean isVarArg, Class<?>[] parameterTypes, String profile) {
        this.target = target;
        this.commandType = commandType;
        this.synchronization = synchronization;
        this.isVarArg = isVarArg;
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
        this.profile = profile;
        this.allProfiles = profile != null ? profile.equals("#ANY_PROFILE#") : true;
    }

    public boolean isSynchronous() {
        return TaskCommand.SynchronizationPolicy.SYNCHRONOUS.equals((Object)this.synchronization);
    }

    public Task.CommandType getCommandType() {
        return this.commandType;
    }

    public int length() {
        return this.parameterTypes.length;
    }

    public boolean isProfile(String profile) {
        if (this.allProfiles) {
            return true;
        }
        return this.profile.equals(profile);
    }

    public boolean isProfile(String[] profile) {
        int index;
        if (profile == null) {
            return false;
        }
        int length = profile.length;
        for (index = 0; index < length && !this.isProfile(profile[index]); ++index) {
        }
        return index < length;
    }

    public boolean isAllTargets() {
        switch (this.getName()) {
            case "/": 
            case "*": 
            case "/*": 
            case "#ANY_TARGET#": {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.target;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() == String.class) {
            return object.equals(this.target);
        }
        if (Signature.class.isAssignableFrom(object.getClass()) && ((Signature)object).getName().equals(this.commandType.name())) {
            return this.equals(((Signature)object).getParameterTypes());
        }
        if (object.getClass().isArray() && Class.class == object.getClass().getComponentType()) {
            int index;
            int length;
            if (this.isVarArg) {
                return true;
            }
            Class[] parameterTypes = (Class[])object;
            int n = length = parameterTypes == null ? 0 : parameterTypes.length;
            if (this.parameterTypes.length != length) {
                return false;
            }
            for (index = 0; index < length && CastUtils.isAssignableFrom(this.parameterTypes[index], (Class)parameterTypes[index]); ++index) {
            }
            return index == length;
        }
        if (object.getClass() == Task.CommandType.class) {
            return this.commandType.equals(object);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n*************************************");
        builder.append("TARGET : ");
        builder.append(this.target);
        builder.append("\n");
        builder.append("COMMAND : ");
        builder.append(this.commandType.name());
        builder.append("\n");
        builder.append("IS SYNCHRONIZED : ");
        builder.append(this.synchronization.name());
        builder.append("\n");
        builder.append("PROFILE : ");
        builder.append(this.profile);
        builder.append("\n");
        builder.append("PARAMETERS : ");
        builder.append(this.parameterTypes == null ? "null" : Arrays.toString(this.parameterTypes));
        builder.append("\n");
        builder.append("HANDLE ALL PROFILES : ");
        builder.append(this.allProfiles);
        builder.append("\n");
        builder.append("IS VAR ARGS : ");
        builder.append(this.isVarArg);
        builder.append("\n");
        builder.append("*************************************\n");
        return builder.toString();
    }
}

