/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.DefaultResourceConfigBuilder;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfigBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfigCatalog;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.security.AccessNodeImpl;
import org.eclipse.sensinact.gateway.core.security.AccessTreeImpl;
import org.eclipse.sensinact.gateway.generic.Connector;
import org.eclipse.sensinact.gateway.generic.ConnectorCustomizer;
import org.eclipse.sensinact.gateway.generic.ExtResourceConfig;
import org.eclipse.sensinact.gateway.generic.ExtResourceConfigCatalog;
import org.eclipse.sensinact.gateway.generic.ExtResourceImpl;
import org.eclipse.sensinact.gateway.generic.ExtServiceImpl;
import org.eclipse.sensinact.gateway.generic.ExtServiceProviderImpl;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.parser.Commands;
import org.eclipse.sensinact.gateway.generic.parser.FixedProviders;
import org.eclipse.sensinact.gateway.generic.parser.XmlResourceConfigHandler;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ExtModelConfiguration<P extends Packet>
extends ModelConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ExtModelConfiguration.class);
    protected boolean isDesynchronized;
    protected boolean lockedAtInitializationTime;
    protected Class<P> packetType;
    protected ConnectorCustomizer<P> customizer;
    protected Class<? extends Connector<P>> connectorType;
    protected Commands commands;
    protected Map<String, String> fixedProviders;

    public static boolean compareBytesArrays(byte[] base, byte[] compare) {
        if (base == null) {
            return compare == null;
        }
        if (compare == null) {
            return false;
        }
        if (base.length != compare.length) {
            return false;
        }
        for (int index = 0; index < base.length; ++index) {
            if (base[index] == compare[index]) continue;
            return false;
        }
        return true;
    }

    public ExtModelConfiguration(Mediator mediator, AccessTreeImpl<? extends AccessNodeImpl<?>> accessTree, Class<P> packetType, String configurationFile, Map<String, String> defaults) throws ParserConfigurationException, SAXException, IOException {
        this(mediator, accessTree, packetType, (ResourceConfigBuilder)new DefaultResourceConfigBuilder(), configurationFile, defaults);
    }

    public ExtModelConfiguration(Mediator mediator, AccessTreeImpl<? extends AccessNodeImpl<?>> accessTree, Class<P> packetType, ResourceConfigBuilder defaultResourceConfigBuilder, String configurationFile, Map<String, String> defaults) throws ParserConfigurationException, SAXException, IOException {
        this(mediator, accessTree, packetType, defaultResourceConfigBuilder, configurationFile, defaults, ExtServiceProviderImpl.class, ExtServiceImpl.class, ExtResourceImpl.class);
    }

    protected ExtModelConfiguration(Mediator mediator, AccessTreeImpl<?> accessTree, Class<P> packetType, ResourceConfigBuilder defaultResourceConfigBuilder, String configurationFile, Map<String, String> defaults, Class<? extends ExtServiceProviderImpl> defaultServiceProviderType, Class<? extends ExtServiceImpl> defaultServiceType, Class<? extends ExtResourceImpl> defaultResourceType) throws ParserConfigurationException, SAXException, IOException {
        this(mediator, accessTree, packetType, defaultResourceConfigBuilder, configurationFile != null ? mediator.getContext().getBundle().getResource(configurationFile) : null, defaults, defaultServiceProviderType, defaultServiceType, defaultResourceType);
    }

    public ExtModelConfiguration(Mediator mediator, AccessTreeImpl<?> accessTree, Class<P> packetType, ResourceConfigBuilder defaultResourceConfigBuilder, URL configurationFile, Map<String, String> defaults, Class<? extends ExtServiceProviderImpl> defaultServiceProviderType, Class<? extends ExtServiceImpl> defaultServiceType, Class<? extends ExtResourceImpl> defaultResourceType) throws ParserConfigurationException, SAXException, IOException {
        super(mediator, accessTree, defaultResourceConfigBuilder, defaultServiceProviderType, defaultServiceType, defaultResourceType);
        this.packetType = packetType;
        super.setResourceConfigType(ExtResourceConfig.class);
        XmlResourceConfigHandler handler = ExtResourceConfig.loadFromXml(mediator, configurationFile);
        HashMap<String, String> builtFixedProviders = new HashMap<String, String>();
        HashMap<String, List<String>> builtFixed = new HashMap<String, List<String>>();
        HashMap<String, List<String>> builtProfiles = new HashMap<String, List<String>>();
        if (handler != null) {
            this.commands = handler.getCommandDefinitions();
            FixedProviders fixedProviders = handler.getDeviceDefinitions();
            builtFixedProviders.putAll(fixedProviders.getProviderMap());
            builtFixed.putAll(fixedProviders.getFixedMap());
            builtProfiles.putAll(handler.getProfiles());
            super.addResourceConfigCatalog((ResourceConfigCatalog)new ExtResourceConfigCatalog(handler, defaults));
        } else {
            this.commands = new Commands(null);
        }
        Enumeration catalogs = mediator.getContext().getBundle().findEntries("/org/eclipse/sensinact/gateway/catalog/", "*.xml", false);
        if (catalogs != null) {
            while (catalogs.hasMoreElements()) {
                URL catalog = (URL)catalogs.nextElement();
                if (catalog == null || !catalog.toExternalForm().endsWith(".xml")) continue;
                try {
                    handler = ExtResourceConfig.loadFromXml(mediator, catalog);
                    if (handler == null) continue;
                    FixedProviders fixedProviders = handler.getDeviceDefinitions();
                    builtFixedProviders.putAll(fixedProviders.getProviderMap());
                    builtFixed.putAll(fixedProviders.getFixedMap());
                    for (Map.Entry<String, List<String>> entry : handler.getProfiles().entrySet()) {
                        if (builtProfiles.containsKey(entry.getKey())) {
                            ((List)builtProfiles.get(entry.getKey())).addAll((Collection)entry.getValue());
                            continue;
                        }
                        builtProfiles.put(entry.getKey(), entry.getValue());
                    }
                    super.addResourceConfigCatalog((ResourceConfigCatalog)new ExtResourceConfigCatalog(handler, defaults));
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    LOG.debug("%s does not contains a valid catalog", (Object)catalog.toExternalForm());
                }
            }
        }
        this.fixed = Collections.unmodifiableMap(builtFixed);
        this.profiles = Collections.unmodifiableMap(builtProfiles);
        this.fixedProviders = Collections.unmodifiableMap(builtFixedProviders);
        LOG.info("ExtModelConfiguration initialized...");
    }

    public ExtModelConfiguration<P> setDefaultResourceType(Class<? extends Resource> defaultResourceType) {
        super.setDefaultResourceType(defaultResourceType);
        return this;
    }

    public ExtModelConfiguration<P> setDefaultDataType(Class<?> defaultDataType) {
        super.setDefaultDataType(defaultDataType);
        return this;
    }

    public ExtModelConfiguration<P> setDefaultModifiable(Modifiable defaultModifiable) {
        super.setDefaultModifiable(defaultModifiable);
        return this;
    }

    public ExtModelConfiguration<P> setDefaultUpdatePolicy(Resource.UpdatePolicy defaultUpdatePolicy) {
        super.setDefaultUpdatePolicy(defaultUpdatePolicy);
        return this;
    }

    public ExtModelConfiguration<P> setProviderImplementationType(Class<? extends ServiceProviderImpl> serviceProviderType) {
        super.setProviderImplementationType(serviceProviderType);
        return this;
    }

    public ExtModelConfiguration<P> setServiceImplmentationType(Class<? extends ServiceImpl> serviceType) {
        super.setServiceImplmentationType(serviceType);
        return this;
    }

    public ExtModelConfiguration<P> setResourceImplementationType(Class<? extends ResourceImpl> resourceType) {
        super.setResourceImplementationType(resourceType);
        return this;
    }

    public ExtModelConfiguration<P> setLockedAtInitializationTime(boolean lockedAtInitializationTime) {
        this.lockedAtInitializationTime = lockedAtInitializationTime;
        return this;
    }

    public boolean isLockedAtInitializationTime() {
        return this.lockedAtInitializationTime;
    }

    public ExtModelConfiguration<P> setDesynchronized(boolean isDesynchronized) {
        this.isDesynchronized = isDesynchronized;
        return this;
    }

    public boolean isDesynchronized() {
        return this.isDesynchronized;
    }

    public void setConnectorCustomizer(ConnectorCustomizer<P> customizer) {
        this.customizer = customizer;
    }

    public ExtModelConfiguration<P> setConnectorType(Class<? extends Connector<P>> connectorType) {
        this.connectorType = connectorType;
        return this;
    }

    public byte[] getCommandIdentifier(Task.CommandType commandType) {
        return this.commands.getCommand(commandType);
    }

    public Commands getCommands() {
        return this.commands;
    }

    public Map<String, String> getFixedProviders() {
        return Collections.unmodifiableMap(this.fixedProviders);
    }

    public Class<P> getPacketType() {
        return this.packetType;
    }

    public Connector<P> connect(ProtocolStackEndpoint<P> endpoint) throws InvalidProtocolStackException {
        Connector<P> connector = null;
        try {
            connector = this.newConnector(endpoint);
        }
        catch (ClassCastException e) {
            throw new InvalidProtocolStackException(e);
        }
        return connector;
    }

    protected Connector<P> newConnector(ProtocolStackEndpoint<P> endpoint) throws InvalidProtocolStackException {
        Connector<P> connector = null;
        connector = this.connectorType != null ? (this.customizer != null ? (Connector)ReflectUtils.getTheBestInstance(this.connectorType, (Object[])new Object[]{this.mediator, endpoint, this, this.customizer}) : (Connector<P>)ReflectUtils.getTheBestInstance(this.connectorType, (Object[])new Object[]{this.mediator, endpoint, this})) : (this.customizer != null ? new Connector<P>(this.mediator, endpoint, this, this.customizer) : new Connector(this.mediator, endpoint, this));
        return connector;
    }
}

