/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.local;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.annotation.AnnotationResolver;
import org.eclipse.sensinact.gateway.generic.annotation.TaskCommand;
import org.eclipse.sensinact.gateway.generic.annotation.TaskExecution;
import org.eclipse.sensinact.gateway.generic.local.AnnotationExecutor;
import org.eclipse.sensinact.gateway.generic.local.GenericLocalTask;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProtocolStackEndpoint<P extends Packet>
extends ProtocolStackEndpoint<P> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalProtocolStackEndpoint.class);
    public static final Task.RequestType REQUEST_TYPE = Task.RequestType.LOCAL;
    private List<AnnotationExecutor> executors;
    private Map<PathCommandKey, AnnotationExecutor> cache;
    private AnnotationResolver resolver;

    public LocalProtocolStackEndpoint(Mediator mediator) {
        this.resolver = new AnnotationResolver(mediator);
        this.executors = new ArrayList<AnnotationExecutor>();
        this.cache = new HashMap<PathCommandKey, AnnotationExecutor>();
        this.buildExecutors();
    }

    @Override
    public void connect(ExtModelConfiguration<P> manager) throws InvalidProtocolStackException {
        this.resolver.addInjectableInstance(LocalProtocolStackEndpoint.class, this);
        this.resolver.addInjectableInstance(ExtModelConfiguration.class, manager);
        this.resolver.buildInjected();
        super.connect(manager);
    }

    @Override
    public Task.RequestType getRequestType() {
        return REQUEST_TYPE;
    }

    @Override
    public void send(Task task) {
        try {
            this.execute(task);
        }
        catch (Exception e) {
            task.abort(AccessMethod.EMPTY);
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public <T> void addInjectableInstance(Class<T> injectableType, T injectable) {
        this.resolver.addInjectableInstance(injectableType, injectable);
    }

    public <T> void addInjectableInstance(T injectable) {
        this.addInjectableInstance(injectable.getClass(), injectable);
    }

    private void buildExecutors() {
        for (final Object instance : this.resolver) {
            Map instanceMap = ReflectUtils.getAnnotatedMethods(instance.getClass(), TaskCommand.class);
            if (instanceMap.isEmpty()) continue;
            for (Map.Entry methodEntry : instanceMap.entrySet()) {
                final Method method = (Method)methodEntry.getKey();
                TaskCommand annotation = (TaskCommand)methodEntry.getValue();
                String target = annotation.target();
                Task.CommandType command = annotation.method();
                TaskCommand.SynchronizationPolicy sync = annotation.synchronization();
                TaskExecution taskInvoker = instance.getClass().getAnnotation(TaskExecution.class);
                String[] profiles = taskInvoker.profile();
                if (profiles == null || profiles.length == 0) {
                    profiles = new String[]{"#ANY_PROFILE#"};
                }
                int length = profiles.length;
                for (int index = 0; index < length; ++index) {
                    AnnotationExecutor executor = new AnnotationExecutor(target, command, sync, method.isVarArgs(), method.getParameterTypes(), profiles[index]){

                        public Object execute(Task task) throws Exception {
                            Object[] objectArray;
                            method.setAccessible(true);
                            Object[] taskParameters = task.getParameters();
                            int length = taskParameters == null || method.isVarArgs() && Array.getLength(taskParameters) == 0 ? 0 : taskParameters.length;
                            Object[] parameters = new Object[length + 1];
                            parameters[0] = task.getPath();
                            if (length > 0) {
                                System.arraycopy(taskParameters, 0, parameters, 1, length);
                            }
                            if (method.isVarArgs()) {
                                Object[] objectArray2 = new Object[1];
                                objectArray = objectArray2;
                                objectArray2[0] = parameters;
                            } else {
                                objectArray = parameters;
                            }
                            Object result = method.invoke(instance, objectArray);
                            if (this.isSynchronous()) {
                                task.setResult(result);
                            }
                            return result;
                        }
                    };
                    this.executors.add(executor);
                }
            }
        }
        Collections.sort(this.executors, new Comparator<AnnotationExecutor>(){

            @Override
            public int compare(AnnotationExecutor basis1, AnnotationExecutor basis2) {
                boolean basis1AllProfile = basis1.isProfile("#ANY_PROFILE#");
                boolean basis2AllProfile = basis2.isProfile("#ANY_PROFILE#");
                boolean basis1AllTargets = basis1.isAllTargets();
                boolean basis2AllTargets = basis2.isAllTargets();
                if (basis1AllProfile == basis2AllProfile) {
                    if (basis1AllTargets && !basis2AllTargets) {
                        return 1;
                    }
                    if (!basis1AllTargets && basis2AllTargets) {
                        return -1;
                    }
                    int basis1WildcardIndex = basis1.getName().indexOf(42);
                    int basis2WildcardIndex = basis2.getName().indexOf(42);
                    if (basis1WildcardIndex > -1 && basis2WildcardIndex == -1) {
                        return 1;
                    }
                    if (basis1WildcardIndex == -1 && basis2WildcardIndex > -1) {
                        return -1;
                    }
                    if (basis1WildcardIndex > -1 && basis2WildcardIndex > -1) {
                        int j;
                        int i;
                        String[] thisPathElements = UriUtils.getUriElements((String)basis1.getName());
                        String[] thatPathElements = UriUtils.getUriElements((String)basis2.getName());
                        for (i = 0; i < thisPathElements.length && !"*".equals(thisPathElements[i]); ++i) {
                        }
                        for (j = 0; j < thatPathElements.length && !"*".equals(thatPathElements[j]); ++j) {
                        }
                        if (i == j) {
                            int l;
                            int k;
                            for (k = i + 1; k < thisPathElements.length && !"*".equals(thisPathElements[k]); ++k) {
                            }
                            k = k == thisPathElements.length ? 0 : k;
                            for (l = j + 1; l < thatPathElements.length && !"*".equals(thatPathElements[l]); ++l) {
                            }
                            l = l == thatPathElements.length ? 0 : l;
                            i = k;
                            j = l;
                        }
                        return i < j ? -1 : 1;
                    }
                    return basis1.length() < basis2.length() ? 1 : -1;
                }
                return basis1AllProfile ? 1 : -1;
            }
        });
    }

    protected Object execute(Task task) throws Exception {
        PathCommandKey key;
        AnnotationExecutor executor;
        String path = task.getPath();
        Task.CommandType commandType = task.getCommand();
        String profile = task.getProfile();
        if (profile == null) {
            profile = "#ANY_PROFILE#";
        }
        if ((executor = this.cache.get(key = new PathCommandKey(path, profile, commandType))) == null) {
            int index;
            Object[] parameters = task.getParameters();
            int length = parameters == null ? 0 : parameters.length;
            Class[] parameterTypes = new Class[++length];
            parameterTypes[0] = String.class;
            for (index = 1; index < length; ++index) {
                parameterTypes[index] = parameters[index - 1] == null ? Object.class : parameters[index - 1].getClass();
            }
            ListIterator<AnnotationExecutor> iterator = this.executors.listIterator();
            while (iterator.hasNext()) {
                String[] thatPathElements;
                int thatLength;
                executor = (AnnotationExecutor)iterator.next();
                if (!(executor.equals((Object)commandType) && executor.equals(parameterTypes) && executor.isProfile(profile))) {
                    executor = null;
                    continue;
                }
                String[] thisPathElements = UriUtils.getUriElements((String)path);
                int thisLength = thisPathElements.length;
                if (thisLength < (thatLength = (thatPathElements = UriUtils.getUriElements((String)executor.getName())).length)) {
                    executor = null;
                    continue;
                }
                for (index = 0; index < thatLength && (thatPathElements[index].equals("*") || thatPathElements[index].equals(thisPathElements[index])); ++index) {
                }
                if (index >= thatLength) break;
                executor = null;
            }
            if (executor == null) {
                executor = new EmptyAnnotationExecutor(path, commandType, parameterTypes, profile);
            }
            this.cache.put(key, executor);
        }
        return executor.execute(task);
    }

    @Override
    public Task createTask(Task.CommandType command, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        GenericLocalTask task = super.wrap(Task.class, new GenericLocalTask(command, this, path, profileId, resourceConfig, parameters));
        return task;
    }

    private class PathCommandKey {
        public final String path;
        public final Task.CommandType command;
        public final String profileId;
        private final int hash;

        PathCommandKey(String path, String profileId, Task.CommandType command) {
            this.path = path;
            this.command = command;
            this.profileId = profileId;
            this.hash = (path + "_" + profileId + "_" + (Object)((Object)command)).hashCode();
        }

        public boolean equals(Object object) {
            if (object.getClass() == PathCommandKey.class) {
                PathCommandKey key = (PathCommandKey)object;
                return key.hashCode() == this.hash;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class EmptyAnnotationExecutor
    extends AnnotationExecutor {
        EmptyAnnotationExecutor(String target, Task.CommandType commandType, Class<?>[] parameterTypes, String profile) {
            super(target, commandType, TaskCommand.SynchronizationPolicy.SYNCHRONOUS, false, parameterTypes, profile);
        }

        public Object execute(Task task) throws Exception {
            task.abort(AccessMethod.EMPTY);
            return AccessMethod.EMPTY;
        }
    }
}

