/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo.internal;

import java.io.Console;
import java.security.InvalidKeyException;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.sensinact.gateway.commands.gogo.osgi.CommandServiceMediator;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;

public class UserCommands {
    private CommandServiceMediator mediator;

    public UserCommands(CommandServiceMediator mediator) {
        this.mediator = mediator;
    }

    @Descriptor(value="switch to the anonymous user")
    public void su() {
        try {
            this.mediator.switchUser();
        }
        catch (InvalidCredentialException e) {
            System.out.println("Invalid credentials. Try again.");
        }
        catch (DataStoreException e) {
            System.out.println("Unable to switch to user anonymous. Problem accessing the DataStore.");
        }
        catch (InvalidKeyException e) {
            System.out.println("Unable to switch to user anonymous. Invalid inputs.");
        }
    }

    @Descriptor(value="switch to another user")
    public void su(@Descriptor(value="the user login") String userID) {
        Console console = System.console();
        char[] passwordChar = console.readPassword("Enter the password: ", new Object[0]);
        try {
            this.mediator.switchUser(userID, new String(passwordChar));
        }
        catch (InvalidCredentialException e) {
            System.out.println("Invalid credentials. Try again.");
        }
        catch (DataStoreException e) {
            System.out.println("Unable to switch to user " + userID + ". Problem accessing the DataStore.");
        }
        catch (InvalidKeyException e) {
            System.out.println("Unable to switch to user " + userID + ". Invalid inputs.");
        }
    }

    @Descriptor(value="information about the current user")
    public void info() {
        System.out.println("Current user: " + this.mediator.getCurrentUser());
    }
}

