/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.historic.storage.agent.generic;

import org.eclipse.sensinact.gateway.historic.storage.agent.generic.Stack;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StorageConnection {
    private static final Logger LOG = LoggerFactory.getLogger(StorageConnection.class);
    protected Stack stack = new Stack();
    private boolean running = true;

    protected abstract void store(JSONObject var1);

    public StorageConnection() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                while (StorageConnection.this.running) {
                    try {
                        JSONObject element = StorageConnection.this.stack.pop();
                        if (element != null) {
                            StorageConnection.this.store(element);
                            continue;
                        }
                        if (StorageConnection.this.shortSleep(200L)) continue;
                        StorageConnection.this.running = false;
                    }
                    catch (Exception e) {
                        LOG.error("POP thread error", (Throwable)e);
                    }
                }
            }
        };
        new Thread(runner).start();
    }

    protected void close() {
        for (int i = 0; i < 10000 && !this.stack.isEmpty() && this.shortSleep(200L); ++i) {
        }
        this.running = false;
        LOG.info("close operation ended");
    }

    private boolean shortSleep(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
    }
}

