/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.mqtt.inst.internal;

import java.io.IOException;
import org.eclipse.sensinact.gateway.agent.mqtt.generic.internal.AbstractMqttHandler;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnaEventEventHandler
extends AbstractMqttHandler {
    Logger LOG = LoggerFactory.getLogger((String)SnaEventEventHandler.class.getName());
    private final String prefix;

    public SnaEventEventHandler(String prefix) throws IOException {
        this.prefix = prefix;
    }

    public void doHandle(SnaUpdateMessageImpl event) {
        try {
            this.LOG.debug("Event received update:" + event.getJSON().toString());
            JSONObject eventJson = new JSONObject(event.getJSON()).getJSONObject("notification");
            String provider = event.getPath().split("/")[1];
            String service = event.getPath().split("/")[2];
            String resource = event.getPath().split("/")[3];
            String valueProperty = event.getPath().split("/")[4];
            Object value = eventJson.get(valueProperty);
            switch ((SnaUpdateMessage.Update)event.getType()) {
                case ATTRIBUTE_VALUE_UPDATED: {
                    this.agent.publish(String.format("%s%s/%s/%s", this.prefix, provider, service, resource), String.valueOf(value));
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("Failed", (Throwable)e);
        }
    }
}

