/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.io.ClientInvoker;
import org.apache.aries.rsa.provider.fastbin.io.ServerInvoker;
import org.apache.aries.rsa.provider.fastbin.tcp.ClientInvokerImpl;
import org.apache.aries.rsa.provider.fastbin.tcp.ServerInvokerImpl;
import org.apache.aries.rsa.provider.fastbin.util.UuidGenerator;
import org.apache.aries.rsa.spi.DistributionProvider;
import org.apache.aries.rsa.spi.Endpoint;
import org.apache.aries.rsa.spi.IntentUnsatisfiedException;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastBinProvider
implements DistributionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FastBinProvider.class);
    public static final String FASTBIN_CONFIG_TYPE = "aries.fastbin";
    public static final String FASTBIN_ADDRESS = "aries.fastbin.address";
    private final String uri;
    private final String exportedAddress;
    private final long timeout;
    private final DispatchQueue queue = Dispatch.createQueue();
    private final Map<String, SerializationStrategy> serializationStrategies = new ConcurrentHashMap<String, SerializationStrategy>();
    private ClientInvoker client;
    private ServerInvoker server;

    public FastBinProvider(String uri, String exportedAddress, long timeout) throws Exception {
        this.uri = uri;
        this.exportedAddress = exportedAddress;
        this.timeout = timeout;
        this.client = new ClientInvokerImpl(this.queue, timeout, this.serializationStrategies);
        this.server = new ServerInvokerImpl(uri, this.queue, this.serializationStrategies);
        this.client.start();
        this.server.start();
    }

    public void close() {
        this.client.stop();
        Semaphore counter = new Semaphore(0);
        this.server.stop(() -> counter.release(1));
        try {
            if (!counter.tryAcquire(1, 30L, TimeUnit.SECONDS)) {
                LOG.warn("Server/Client failed to shut down in time. Proceeding shutdown anyway...");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for Server/Client shutdown");
        }
    }

    public ClientInvoker getClient() {
        return this.client;
    }

    public ServerInvoker getServer() {
        return this.server;
    }

    public String[] getSupportedTypes() {
        return new String[]{FASTBIN_CONFIG_TYPE};
    }

    public Endpoint exportService(final Object serviceO, BundleContext serviceContext, Map<String, Object> effectiveProperties, Class[] exportedInterfaces) {
        String endpointId = UuidGenerator.getUUID();
        effectiveProperties.put("endpoint.id", endpointId);
        URI connectUri = URI.create(this.server.getConnectAddress());
        String fastbinAddress = connectUri.getScheme() + "://" + this.exportedAddress + ":" + connectUri.getPort();
        effectiveProperties.put(FASTBIN_ADDRESS, fastbinAddress);
        effectiveProperties.put("service.imported.configs", this.getSupportedTypes());
        final EndpointDescription description = new EndpointDescription(effectiveProperties);
        this.server.registerService(description.getId(), new ServerInvoker.ServiceFactory(){

            @Override
            public Object get() {
                return serviceO;
            }

            @Override
            public void unget() {
            }
        }, serviceO.getClass().getClassLoader());
        return new Endpoint(){

            public EndpointDescription description() {
                return description;
            }

            public void close() throws IOException {
                FastBinProvider.this.server.unregisterService(description.getId());
            }
        };
    }

    public Object importEndpoint(ClassLoader cl, BundleContext consumerContext, Class[] interfaces, EndpointDescription endpoint) throws IntentUnsatisfiedException {
        String address = (String)endpoint.getProperties().get(FASTBIN_ADDRESS);
        InvocationHandler handler = this.client.getProxy(address, endpoint.getId(), cl);
        return Proxy.newProxyInstance(cl, interfaces, handler);
    }
}

