/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.core.security.dao.AbstractMutableSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.BundleDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.entity.AgentEntity;
import org.eclipse.sensinact.gateway.core.security.entity.BundleEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;

public class AgentDAO
extends AbstractMutableSnaDAO<AgentEntity> {
    private BundleDAO bundleDAO;

    public AgentDAO(DataStoreService dataStoreService) throws DAOException {
        super(AgentEntity.class, dataStoreService);
        this.bundleDAO = new BundleDAO(dataStoreService);
    }

    public AgentEntity find(long identifier) throws DAOException, DataStoreException {
        List agentEntities = super.select(Collections.singletonMap("AID", identifier));
        if (agentEntities.size() != 1) {
            return null;
        }
        return (AgentEntity)agentEntities.get(0);
    }

    public AgentEntity find(String publicKey) throws DAOException, DataStoreException {
        List agentEntities = super.select(Collections.singletonMap("APUBLIC_KEY", publicKey));
        if (agentEntities.size() != 1) {
            return null;
        }
        return (AgentEntity)agentEntities.get(0);
    }

    public AgentEntity findFromBundle(String signature) throws DAOException, DataStoreException {
        BundleEntity bundleEntity = this.bundleDAO.find(signature);
        if (bundleEntity == null) {
            return null;
        }
        List agentEntities = super.select(Collections.singletonMap("BID", bundleEntity.getIdentifier()));
        if (agentEntities.size() != 1) {
            return null;
        }
        return (AgentEntity)agentEntities.get(0);
    }
}

