/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao.directive;

import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.security.dao.directive.Directive;
import org.eclipse.sensinact.gateway.core.security.dao.directive.KeyDirective;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Column;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.PrimaryKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Table;

public class DeleteDirective
extends Directive {
    protected KeyDirective keyDirective;

    public static <E extends SnaEntity> DeleteDirective getDeleteDirective(E entity) {
        Class<?> entityType = entity.getClass();
        Table table = entityType.getAnnotation(Table.class);
        Map<Field, Column> fields = SnaEntity.getFields(entityType);
        KeyDirective keyDirective = KeyDirective.createKeyDirective(table, entityType.getAnnotation(PrimaryKey.class), fields);
        keyDirective.assign(entity);
        DeleteDirective deleteDirective = new DeleteDirective(table.value(), keyDirective);
        return deleteDirective;
    }

    public DeleteDirective(String table, KeyDirective keyDirective) {
        super(table);
        this.keyDirective = keyDirective;
    }

    public String toString() {
        String deleteStatement = "DELETE FROM" + " " + this.table + " " + "WHERE" + " " + this.keyDirective.getValueDirective();
        return deleteStatement;
    }
}

