/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao.directive;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.security.dao.directive.Directive;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Column;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.ForeignKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.PrimaryKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Table;

public class KeyDirective
extends Directive {
    private List<KeyEntry> keyEntries = new ArrayList<KeyEntry>();

    public static <E extends SnaEntity> KeyDirective createKeyDirective(Class<E> entityType) {
        return KeyDirective.createKeyDirective(entityType.getAnnotation(Table.class), entityType.getAnnotation(PrimaryKey.class), SnaEntity.getFields(entityType));
    }

    public static <E extends SnaEntity> KeyDirective createKeyDirective(Table table, PrimaryKey primaryKey, Map<Field, Column> fields) {
        int length;
        KeyDirective keyDirective = new KeyDirective(table.value());
        String[] keys = primaryKey == null ? null : primaryKey.value();
        int n = length = keys == null ? 0 : keys.length;
        if (length > 0) {
            for (Map.Entry<Field, Column> entry : fields.entrySet()) {
                String fieldAnnotation = entry.getValue().value();
                for (int index = 0; index < length; ++index) {
                    if (!keys[index].equals(fieldAnnotation)) continue;
                    ForeignKey foreignAnnotation = entry.getKey().getAnnotation(ForeignKey.class);
                    if (foreignAnnotation == null) {
                        keyDirective.addKeyEntry(keys[index]);
                        continue;
                    }
                    keyDirective.addForeignKeyEntry(keys[index], foreignAnnotation.table(), foreignAnnotation.refer());
                }
            }
        }
        return keyDirective;
    }

    public KeyDirective(String table) {
        super(table);
    }

    protected void join(KeyDirective keyDirective) {
        this.keyEntries.addAll(keyDirective.keyEntries);
    }

    public void assign(SnaEntity entity) {
        this.assign(entity.getKeys());
    }

    public void assign(List<SnaEntity.Key> keyList) {
        for (SnaEntity.Key entry : keyList) {
            this.assign(entry.getName(), entry.value());
        }
    }

    public void assign(String name, Object value) {
        this.keyEntries.stream().filter(k -> name.equals(k.getName())).findFirst().ifPresent(k -> k.setValue(value));
    }

    protected void reset() {
        this.keyEntries.forEach(k -> k.setValue(-1));
    }

    public KeyEntry addKeyEntry(String column) {
        KeyEntry keyEntry = new KeyEntry(column);
        this.keyEntries.add(keyEntry);
        return keyEntry;
    }

    public ForeignKeyEntry addForeignKeyEntry(String column, String foreignTable, String foreignColumn) {
        ForeignKeyEntry keyEntry = new ForeignKeyEntry(column, foreignTable, foreignColumn);
        this.keyEntries.add(keyEntry);
        return keyEntry;
    }

    public String getValueDirective() {
        StringBuilder builder = new StringBuilder();
        for (KeyEntry entry : this.keyEntries) {
            if (entry.getValue() == null) continue;
            if (builder.length() > 0) {
                builder.append(" ").append("AND").append(" ");
            }
            super.buildEqualityDirective(builder, entry.getColumn(), entry.getValue());
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (KeyEntry entry : this.keyEntries) {
            if (!ForeignKeyEntry.class.isAssignableFrom(entry.getClass())) continue;
            if (builder.length() > 0) {
                builder.append(" ").append("AND").append(" ");
            }
            builder.append(((ForeignKeyEntry)entry).getForeignTable()).append(".").append(((ForeignKeyEntry)entry).getForeignColumn()).append("=").append(super.getColumnName(entry.getColumn()));
        }
        return builder.toString();
    }

    public class KeyEntry
    implements Nameable {
        private final String column;
        private String name = null;
        private Object value = null;

        public KeyEntry(String column) {
            this.column = column;
        }

        public String getColumn() {
            return this.column;
        }

        public Object getValue() {
            return this.value;
        }

        void setValue(Object value) {
            this.value = value;
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.generateName();
            }
            return this.name;
        }

        protected String generateName() {
            return KeyDirective.this.getColumnName(this.column);
        }
    }

    class ForeignKeyEntry
    extends KeyEntry {
        private final String foreignTable;
        private final String foreignColumn;

        public ForeignKeyEntry(String column, String foreignTable, String foreignColumn) {
            super(column);
            this.foreignTable = foreignTable;
            this.foreignColumn = foreignColumn;
        }

        public String getForeignTable() {
            return this.foreignTable;
        }

        public String getForeignColumn() {
            return this.foreignColumn;
        }

        @Override
        protected String generateName() {
            return this.foreignTable + "." + this.foreignColumn;
        }
    }
}

