/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao.directive;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.security.dao.directive.Directive;
import org.eclipse.sensinact.gateway.core.security.dao.directive.KeyDirective;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Column;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.PrimaryKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Table;
import org.eclipse.sensinact.gateway.util.ReflectUtils;

public class SelectDirective
extends Directive {
    protected Map<String, List<String>> select;
    protected Map<String, Object> where;
    protected KeyDirective keyDirective;

    static <E extends SnaEntity> SelectDirective getSelectDirective(Class<E> entityType, Map<Field, Column> fields) {
        Table table = entityType.getAnnotation(Table.class);
        KeyDirective keyDirective = KeyDirective.createKeyDirective(table, entityType.getAnnotation(PrimaryKey.class), fields);
        SelectDirective selectDirective = new SelectDirective(table.value(), keyDirective);
        for (Map.Entry<Field, Column> entry : fields.entrySet()) {
            selectDirective.select(table.value(), entry.getValue().value());
        }
        selectDirective.join(keyDirective);
        return selectDirective;
    }

    public static <E extends SnaEntity> SelectDirective getSelectDirective(Class<E> entityType) {
        return SelectDirective.getSelectDirective(entityType, ReflectUtils.getAnnotatedFields(entityType, Column.class));
    }

    public SelectDirective(String table, KeyDirective keyDirective) {
        super(table);
        this.keyDirective = keyDirective;
        this.select = new HashMap<String, List<String>>();
        this.where = new HashMap<String, Object>();
    }

    public void select(String table, String column) {
        List<String> list;
        if (column == null || column.length() == 0) {
            return;
        }
        String targetedTable = table;
        if (table == null || table.length() == 0) {
            targetedTable = this.table;
        }
        if ((list = this.select.get(targetedTable)) == null) {
            list = new ArrayList<String>();
            this.select.put(targetedTable, list);
        }
        list.add(column);
    }

    public void where(String column, Object value) {
        if (column == null || column.length() == 0) {
            return;
        }
        this.where.put(column, value);
    }

    public void join(SelectDirective selectDirective) {
        if (selectDirective == null) {
            return;
        }
        this.select.putAll(selectDirective.select);
        this.where.putAll(selectDirective.where);
        this.keyDirective.join(selectDirective.keyDirective);
    }

    public void join(KeyDirective keyDirective) {
        if (keyDirective != null) {
            this.keyDirective.join(keyDirective);
        }
    }

    protected String getColumnName(String table, String column) {
        if (table == null || table.equals(this.table)) {
            return super.getColumnName(column);
        }
        String[] columnElements = column.split(".");
        if (columnElements.length == 2 && table.equals(columnElements[0])) {
            return column;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(table);
        builder.append(".");
        builder.append(column);
        return builder.toString();
    }

    public String toString() {
        if (this.select.isEmpty()) {
            return null;
        }
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append("SELECT").append(" ");
        StringBuilder fromBuilder = new StringBuilder();
        fromBuilder.append(" ").append("FROM").append(" ");
        Iterator<Map.Entry<String, List<String>>> iterator = this.select.entrySet().iterator();
        Map.Entry<String, List<String>> entry = null;
        int fromIndex = 0;
        while (iterator.hasNext()) {
            int length;
            entry = iterator.next();
            List<String> list = entry.getValue();
            int n = length = list == null ? 0 : list.size();
            for (int selectIndex = 0; selectIndex < length; ++selectIndex) {
                if (selectIndex > 0) {
                    selectBuilder.append(",");
                }
                selectBuilder.append(this.getColumnName(entry.getKey(), list.get(selectIndex)));
            }
            if (fromIndex++ > 0) {
                fromBuilder.append(",");
            }
            fromBuilder.append(entry.getKey());
        }
        ArrayList<String> directives = new ArrayList<String>();
        Iterator<Map.Entry<String, Object>> conditionIterator = this.where.entrySet().iterator();
        while (conditionIterator.hasNext()) {
            StringBuilder builder = new StringBuilder();
            super.buildEqualityDirective(builder, conditionIterator.next());
            directives.add(builder.toString());
        }
        String keyDirectiveValue = null;
        if (this.keyDirective != null && (keyDirectiveValue = this.keyDirective.getValueDirective()) != null && keyDirectiveValue.length() > 0) {
            directives.add(keyDirectiveValue);
        }
        StringBuilder whereBuilder = new StringBuilder();
        if (!directives.isEmpty()) {
            whereBuilder.append(" ").append("WHERE").append(" ");
            int length = directives.size();
            for (int index = 0; index < length; ++index) {
                if (index > 0) {
                    whereBuilder.append(" ").append("AND").append(" ");
                }
                whereBuilder.append((String)directives.get(index));
            }
        }
        String selectStatement = selectBuilder.append(fromBuilder.toString()).append(whereBuilder.toString()).toString();
        return selectStatement;
    }
}

